/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.VerifyUserIsMemberOfGroupSpectraS3Response;
import com.spectralogic.ds3client.models.Group;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class VerifyUserIsMemberOfGroupSpectraS3ResponseParser
extends AbstractResponseParser<VerifyUserIsMemberOfGroupSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200, 204};

    @Override
    public VerifyUserIsMemberOfGroupSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        Group result = XmlOutput.fromXml(inputStream, Group.class);
                        VerifyUserIsMemberOfGroupSpectraS3Response verifyUserIsMemberOfGroupSpectraS3Response = new VerifyUserIsMemberOfGroupSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return verifyUserIsMemberOfGroupSpectraS3Response;
                    }
                }
                case 204: {
                    return new VerifyUserIsMemberOfGroupSpectraS3Response(null, this.getChecksum(), this.getChecksumType());
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

