/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.VerifyPhysicalPlacementForObjectsSpectraS3Response;
import com.spectralogic.ds3client.models.PhysicalPlacement;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class VerifyPhysicalPlacementForObjectsSpectraS3ResponseParser
extends AbstractResponseParser<VerifyPhysicalPlacementForObjectsSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public VerifyPhysicalPlacementForObjectsSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        PhysicalPlacement result = XmlOutput.fromXml(inputStream, PhysicalPlacement.class);
                        VerifyPhysicalPlacementForObjectsSpectraS3Response verifyPhysicalPlacementForObjectsSpectraS3Response = new VerifyPhysicalPlacementForObjectsSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return verifyPhysicalPlacementForObjectsSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

