/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.GetServiceResponse;
import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.models.ListAllMyBucketsResult;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetServiceResponseParser
extends AbstractResponseParser<GetServiceResponse> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetServiceResponse parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        ListAllMyBucketsResult result = XmlOutput.fromXml(inputStream, ListAllMyBucketsResult.class);
                        GetServiceResponse getServiceResponse = new GetServiceResponse(result, this.getChecksum(), this.getChecksumType());
                        return getServiceResponse;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

