/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetDataPathBackendSpectraS3Response;
import com.spectralogic.ds3client.models.DataPathBackend;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetDataPathBackendSpectraS3ResponseParser
extends AbstractResponseParser<GetDataPathBackendSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetDataPathBackendSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        DataPathBackend result = XmlOutput.fromXml(inputStream, DataPathBackend.class);
                        GetDataPathBackendSpectraS3Response getDataPathBackendSpectraS3Response = new GetDataPathBackendSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getDataPathBackendSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

