/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.AllocateJobChunkSpectraS3Response;
import com.spectralogic.ds3client.exceptions.RetryAfterExpectedException;
import com.spectralogic.ds3client.models.Objects;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class AllocateJobChunkSpectraS3ResponseParser
extends AbstractResponseParser<AllocateJobChunkSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200, 307, 503};

    @Override
    public AllocateJobChunkSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        Objects result = XmlOutput.fromXml(inputStream, Objects.class);
                        AllocateJobChunkSpectraS3Response allocateJobChunkSpectraS3Response = new AllocateJobChunkSpectraS3Response(result, 0, AllocateJobChunkSpectraS3Response.Status.ALLOCATED, this.getChecksum(), this.getChecksumType());
                        return allocateJobChunkSpectraS3Response;
                    }
                }
                case 307: 
                case 503: {
                    return new AllocateJobChunkSpectraS3Response(null, AllocateJobChunkSpectraS3ResponseParser.parseRetryAfter(response), AllocateJobChunkSpectraS3Response.Status.RETRYLATER, this.getChecksum(), this.getChecksumType());
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }

    private static int parseRetryAfter(WebResponse webResponse) {
        String retryAfter = (String)webResponse.getHeaders().get("Retry-After").get(0);
        if (retryAfter == null) {
            throw new RetryAfterExpectedException();
        }
        return Integer.parseInt(retryAfter);
    }
}

