/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.googlestorage.GoogleStorageObjectListService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.HashSet;

public class GoogleStorageSearchFeature
implements Search {
    private final GoogleStorageSession session;

    public GoogleStorageSearchFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        AttributedList<Path> objects;
        try {
            objects = new GoogleStorageObjectListService(this.session).list(workdir, listener, null, PreferencesFactory.get().getInteger("googlestorage.listing.chunksize"));
        }
        catch (NotfoundException e) {
            return AttributedList.emptyList();
        }
        HashSet<Path> removal = new HashSet<Path>();
        for (Path f : objects) {
            if (f.getName().contains(regex.toPattern().pattern())) continue;
            removal.add(f);
        }
        objects.removeAll(removal);
        return objects;
    }

    public boolean isRecursive() {
        return false;
    }

    public Search withCache(Cache<Path> cache) {
        return this;
    }
}

