/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.cdn.features.DistributionLogging;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.googlestorage.GoogleStorageBucketListService;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.logging.LoggingConfiguration;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GoogleStorageLoggingFeature
implements Logging,
DistributionLogging {
    private static final Logger log = Logger.getLogger(GoogleStorageLoggingFeature.class);
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    final GoogleStorageSession session;

    public GoogleStorageLoggingFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public LoggingConfiguration getConfiguration(Path file) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        if (bucket.isRoot()) {
            return LoggingConfiguration.empty();
        }
        try {
            Bucket.Logging status = ((Bucket)((Storage)this.session.getClient()).buckets().get(bucket.getName()).execute()).getLogging();
            if (null == status) {
                return LoggingConfiguration.empty();
            }
            LoggingConfiguration configuration = new LoggingConfiguration(status.getLogObjectPrefix() != null, status.getLogBucket());
            try {
                configuration.setContainers(new GoogleStorageBucketListService(this.session).list(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)), (ListProgressListener)new DisabledListProgressListener()).toList());
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                log.warn((Object)String.format("Failure listing buckets. %s", e.getMessage()));
            }
            return configuration;
        }
        catch (IOException e) {
            try {
                throw new GoogleStorageExceptionMappingService().map("Failure to read attributes of {0}", e, bucket);
            }
            catch (AccessDeniedException | InteroperabilityException l) {
                log.warn((Object)String.format("Missing permission to read logging configuration for %s %s", bucket.getName(), e.getMessage()));
                return LoggingConfiguration.empty();
            }
        }
    }

    public void setConfiguration(Path container, LoggingConfiguration configuration) throws BackgroundException {
        try {
            ((Storage)this.session.getClient()).buckets().patch(container.getName(), new Bucket().setLogging(new Bucket.Logging().setLogObjectPrefix(configuration.isEnabled() ? PreferencesFactory.get().getProperty("google.logging.prefix") : null).setLogBucket(StringUtils.isNotBlank((CharSequence)configuration.getLoggingTarget()) ? configuration.getLoggingTarget() : container.getName()))).execute();
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Failure to write attributes of {0}", e, container);
        }
    }
}

