/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DBNLegacyUtils {
    private static final Log log = Log.getLog(DBNLegacyUtils.class);

    @Deprecated
    public static DBNNode legacyGetNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBNProject projectNode, @NotNull DBNModel.NodePath nodePath) throws DBException {
        DBNNode curNode = switch (nodePath.type) {
            case DBNNode.NodePathType.database -> projectNode.getDatabases().getDataSource(nodePath.first());
            case DBNNode.NodePathType.folder -> projectNode.getDatabases();
            default -> projectNode;
        };
        if (curNode == null) {
            return null;
        }
        return DBNLegacyUtils.legacyFindNodeByPath(monitor, nodePath, curNode, 1);
    }

    @Deprecated
    public static DBNNode legacyGetNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBNModel model, @NotNull DBNModel.NodePath nodePath) throws DBException {
        block11: {
            block10: {
                DBNDataSource curNode;
                if (nodePath.type != DBNNode.NodePathType.database) break block10;
                boolean hasLazyProjects = false;
                for (DBNProject projectNode : model.getRoot().getProjects()) {
                    if (!projectNode.getProject().isRegistryLoaded()) {
                        hasLazyProjects = true;
                        continue;
                    }
                    curNode = projectNode.getDatabases().getDataSource(nodePath.first());
                    if (curNode == null) continue;
                    return DBNLegacyUtils.legacyFindNodeByPath(monitor, nodePath, curNode, 1);
                }
                if (!hasLazyProjects) break block11;
                for (DBNProject projectNode : model.getRoot().getProjects()) {
                    if (projectNode.getProject().isRegistryLoaded() || (curNode = projectNode.getDatabases().getDataSource(nodePath.first())) == null) continue;
                    return DBNLegacyUtils.legacyFindNodeByPath(monitor, nodePath, curNode, 1);
                }
                break block11;
            }
            if (nodePath.type == DBNNode.NodePathType.ext) {
                DBNNode node = DBNLegacyUtils.legacyFindNodeByPath(monitor, nodePath, model.getRoot(), 0);
                if (node != null) {
                    return node;
                }
                List<DBNProject> projects = model.getRoot().getProjects();
                if (projects.isEmpty()) {
                    throw new DBException("No projects in workspace");
                }
                String projectId = nodePath.first();
                DBNProject parentProjectNode = projectId == null ? null : (DBNProject)projects.stream().filter(dbnProject -> dbnProject.getProject().getId().equals(projectId)).findFirst().orElse(null);
                int firstItem = 0;
                if (parentProjectNode == null) {
                    parentProjectNode = projects.getFirst();
                } else {
                    firstItem = 1;
                }
                return DBNLegacyUtils.legacyFindNodeByPath(monitor, nodePath, parentProjectNode, firstItem);
            }
            if (nodePath.type == DBNNode.NodePathType.other) {
                return DBNLegacyUtils.legacyFindNodeByPath(monitor, nodePath, model.getRoot(), 0);
            }
            for (DBNProject projectNode : model.getRoot().getProjects()) {
                if (!projectNode.getName().equals(nodePath.first())) continue;
                return DBNLegacyUtils.legacyFindNodeByPath(monitor, nodePath, nodePath.type == DBNNode.NodePathType.folder ? projectNode.getDatabases() : projectNode, 1);
            }
        }
        return null;
    }

    @Nullable
    private static DBNNode legacyFindNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBNModel.NodePath nodePath, @NotNull DBNNode curNode, int firstItem) throws DBException {
        String lastItemName;
        List<String> pathItems = nodePath.pathItems;
        int i = firstItem;
        int itemsSize = pathItems.size();
        while (i < itemsSize) {
            String item = pathItems.get(i);
            if (nodePath.type == DBNNode.NodePathType.ext && curNode instanceof DBNProject) {
                DBNProject pn = (DBNProject)curNode;
                pn.getExtraNode(DBNFileSystems.class);
            }
            Object[] children = curNode.getChildren(monitor);
            Object nextChild = null;
            if (children != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (DBNLegacyUtils.nodeMatchesPath(nodePath, (DBNNode)child, item)) {
                        nextChild = child;
                    }
                    if (nextChild != null) {
                        if (i >= itemsSize - 1) break;
                        if ((nextChild = DBNLegacyUtils.legacyFindNodeByPath(monitor, nodePath, (DBNNode)nextChild, i + 1)) != null) {
                            return nextChild;
                        }
                    }
                    ++n2;
                }
            }
            if (nextChild == null) {
                log.debug("Node '" + item + "' not found in parent node '" + curNode.getNodeItemPath() + "'.\nAllowed children: " + Arrays.toString(children));
            }
            if (nextChild != null) {
                curNode = nextChild;
            }
            ++i;
        }
        if (!pathItems.isEmpty() && !DBNLegacyUtils.nodeMatchesPath(nodePath, curNode, lastItemName = pathItems.get(pathItems.size() - 1))) {
            return null;
        }
        return curNode;
    }

    private static boolean nodeMatchesPath(@NotNull DBNModel.NodePath path, @NotNull DBNNode child, @NotNull String item) {
        String idOrType;
        DBXTreeFolder meta;
        if (path.type == DBNNode.NodePathType.resource) {
            if (child instanceof DBNProject && ((DBNProject)child).getProject().getId().equals(item) || child instanceof DBNProjectDatabases && child.getName().equals(item)) {
                return true;
            }
            Path filePath = child.getAdapter(Path.class);
            return filePath != null && filePath.getFileName().toString().equals(item);
        }
        if (path.type == DBNNode.NodePathType.folder) {
            return child instanceof DBNLocalFolder && child.getName().equals(item);
        }
        if (child instanceof DBNDataSource) {
            return ((DBNDataSource)child).getDataSourceContainer().getId().equals(item);
        }
        if (child instanceof DBNDatabaseFolder && (meta = ((DBNDatabaseFolder)child).getMeta()) != null && !CommonUtils.isEmpty((String)(idOrType = meta.getIdOrType())) && idOrType.equals(item)) {
            return true;
        }
        return child.getName().equals(item);
    }
}

