/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreUIUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupInfo;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizard;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizardPage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.utils.CommonUtils;

class PostgreBackupWizardPageObjects
extends AbstractNativeToolWizardPage<PostgreBackupWizard> {
    private static final Log log = Log.getLog(PostgreBackupWizardPageObjects.class);
    private Table schemasTable;
    private Table tablesTable;
    private Map<PostgreSchema, Set<PostgreTableBase>> checkedObjects = new HashMap<PostgreSchema, Set<PostgreTableBase>>();
    private PostgreSchema curSchema;
    private PostgreDatabase dataBase;
    private Button exportViewsCheck;
    private Button fullSchemaBackupCheck;

    PostgreBackupWizardPageObjects(PostgreBackupWizard wizard) {
        super((AbstractNativeToolWizard)wizard, PostgreMessages.wizard_backup_page_object_title_schema_table);
        this.setTitle(PostgreMessages.wizard_backup_page_object_title);
        this.setDescription(PostgreMessages.wizard_backup_page_object_description);
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Composite objectsGroup = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.wizard_backup_page_object_group_object, (int)1, (int)768);
        objectsGroup.setLayoutData((Object)new GridData(1808));
        this.connInfo = new CLabel(objectsGroup, 64);
        this.connInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.connInfo.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.DATABASE_DEFAULT));
        CustomSashForm sash = new CustomSashForm(objectsGroup, 512);
        sash.setLayoutData((Object)new GridData(1808));
        Composite catPanel = UIUtils.createComposite((Composite)sash, (int)1);
        catPanel.setLayoutData((Object)new GridData(1808));
        this.schemasTable = new Table(catPanel, 2080);
        this.schemasTable.addListener(13, event -> {
            TableItem item = (TableItem)event.item;
            PostgreSchema catalog = (PostgreSchema)item.getData();
            if (event.detail == 32) {
                this.schemasTable.select(this.schemasTable.indexOf(item));
                this.checkedObjects.remove(catalog);
            }
            this.loadTables(catalog);
            this.updateState();
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        this.schemasTable.setLayoutData((Object)gd);
        Composite buttonsPanel = UIUtils.createComposite((Composite)catPanel, (int)3);
        this.fullSchemaBackupCheck = UIUtils.createCheckbox((Composite)buttonsPanel, (String)PostgreMessages.wizard_backup_page_object_checkbox_complete_backup, (boolean)false);
        this.fullSchemaBackupCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PostgreDatabaseBackupSettings)((PostgreBackupWizard)PostgreBackupWizardPageObjects.this.wizard).getSettings()).setFullSchemaBackup(PostgreBackupWizardPageObjects.this.fullSchemaBackupCheck.getSelection());
                PostgreBackupWizardPageObjects.this.tablesTable.setVisible(!PostgreBackupWizardPageObjects.this.fullSchemaBackupCheck.getSelection());
            }
        });
        this.fullSchemaBackupCheck.setLayoutData((Object)new GridData(512));
        buttonsPanel.setLayoutData((Object)new GridData(768));
        this.createCheckButtons(buttonsPanel, this.schemasTable);
        Composite tablesPanel = UIUtils.createComposite((Composite)sash, (int)1);
        tablesPanel.setLayoutData((Object)new GridData(1808));
        this.tablesTable = new Table(tablesPanel, 2080);
        gd = new GridData(1808);
        gd.heightHint = 50;
        this.tablesTable.setLayoutData((Object)gd);
        this.tablesTable.addListener(13, event -> {
            if (event.detail == 32) {
                this.updateCheckedTables();
                this.updateState();
            }
        });
        buttonsPanel = UIUtils.createComposite((Composite)tablesPanel, (int)3);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        this.exportViewsCheck = UIUtils.createCheckbox((Composite)buttonsPanel, (String)PostgreMessages.wizard_backup_page_object_checkbox_show_view, (boolean)false);
        this.exportViewsCheck.setSelection(((PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings()).isFullSchemaBackup());
        this.exportViewsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PostgreDatabaseBackupSettings)((PostgreBackupWizard)PostgreBackupWizardPageObjects.this.wizard).getSettings()).setShowViews(PostgreBackupWizardPageObjects.this.exportViewsCheck.getSelection());
                PostgreBackupWizardPageObjects.this.loadTables(null);
            }
        });
        this.exportViewsCheck.setLayoutData((Object)new GridData(512));
        this.createCheckButtons(buttonsPanel, this.tablesTable);
        PostgreUIUtils.addCompatibilityInfoLabelForForks(composite, this.wizard, this.dataBase != null ? this.dataBase.getDataSource() : null);
        this.setControl((Control)composite);
    }

    protected boolean determinePageCompletion() {
        boolean complete = false;
        if (!this.checkedObjects.isEmpty()) {
            complete = true;
        }
        TableItem[] tableItemArray = this.schemasTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                complete = true;
                break;
            }
            ++n2;
        }
        return complete && super.determinePageCompletion();
    }

    public void activatePage() {
        super.activatePage();
        this.loadSettings();
        this.updateState();
    }

    public void deactivatePage() {
        this.saveState();
    }

    private void loadSettings() {
        this.checkedObjects.clear();
        this.schemasTable.removeAll();
        this.tablesTable.removeAll();
        this.dataBase = null;
        boolean hasViews = false;
        LinkedHashSet<PostgreSchema> activeSchemas = new LinkedHashSet<PostgreSchema>();
        for (PostgreDatabaseBackupInfo info : ((PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings()).getExportObjects()) {
            this.dataBase = info.getDatabase();
            if (!CommonUtils.isEmpty((Collection)info.getSchemas())) {
                activeSchemas.addAll(info.getSchemas());
            }
            if (CommonUtils.isEmpty((Collection)info.getTables())) continue;
            for (PostgreTableBase table : info.getTables()) {
                PostgreTableContainer tableContainer = (PostgreTableContainer)table.getContainer();
                if (!(tableContainer instanceof PostgreSchema)) continue;
                PostgreSchema schema = (PostgreSchema)tableContainer;
                activeSchemas.add(schema);
                Set tables = this.checkedObjects.computeIfAbsent(schema, k -> new HashSet());
                tables.add(table);
                if (!table.isView()) continue;
                hasViews = true;
            }
        }
        if (hasViews) {
            ((PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings()).setShowViews(true);
            this.exportViewsCheck.setSelection(true);
        }
        if (this.dataBase != null) {
            this.setConnectionInfo(this.dataBase.getDataSource().getContainer(), this.dataBase.getName());
            boolean tablesLoaded = false;
            try {
                for (PostgreSchema schema : this.dataBase.getSchemas((DBRProgressMonitor)new VoidProgressMonitor())) {
                    if (schema.isSystem() || schema.isUtility()) continue;
                    TableItem item = new TableItem(this.schemasTable, 0);
                    item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCHEMA));
                    item.setText(0, schema.getName());
                    item.setData((Object)schema);
                    if (!activeSchemas.contains(schema)) continue;
                    item.setChecked(true);
                    this.schemasTable.select(this.schemasTable.indexOf(item));
                    if (tablesLoaded) continue;
                    this.loadTables(schema);
                    tablesLoaded = true;
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private void updateCheckedTables() {
        TableItem[] tableItems;
        HashSet<PostgreTableBase> checkedTables = new HashSet<PostgreTableBase>();
        TableItem[] tableItemArray = tableItems = this.tablesTable.getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                checkedTables.add((PostgreTableBase)item.getData());
            }
            ++n2;
        }
        int selectionIndex = this.schemasTable.getSelectionIndex();
        if (selectionIndex > -1) {
            TableItem catalogItem = this.schemasTable.getItem(selectionIndex);
            catalogItem.setChecked(!checkedTables.isEmpty());
        }
        if (checkedTables.isEmpty() || checkedTables.size() == tableItems.length) {
            this.checkedObjects.remove(this.curSchema);
        } else {
            this.checkedObjects.put(this.curSchema, checkedTables);
        }
    }

    private boolean isChecked(PostgreSchema catalog) {
        TableItem[] tableItemArray = this.schemasTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == catalog) {
                return item.getChecked();
            }
            ++n2;
        }
        return false;
    }

    private List<PostgreTableBase> loadTables(PostgreSchema catalog) {
        if (catalog != null) {
            this.curSchema = catalog;
        }
        if (this.curSchema == null) {
            return null;
        }
        final boolean isCatalogChecked = this.isChecked(this.curSchema);
        final Set<PostgreTableBase> checkedObjects = this.checkedObjects.get(this.curSchema);
        final ArrayList<PostgreTableBase> objects = new ArrayList<PostgreTableBase>();
        new AbstractJob("Load '" + this.curSchema.getName() + "' tables"){
            {
                super($anonymous0);
                this.setUser(true);
            }

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                monitor.beginTask("Collect tables", 1);
                try {
                    try {
                        monitor.subTask("Collect tables to dump");
                        for (JDBCTable table : PostgreBackupWizardPageObjects.this.curSchema.getTables(monitor)) {
                            if (!(table instanceof PostgreTableBase)) continue;
                            objects.add((PostgreTableBase)table);
                        }
                        if (((PostgreDatabaseBackupSettings)((PostgreBackupWizard)PostgreBackupWizardPageObjects.this.wizard).getSettings()).isShowViews()) {
                            objects.addAll(PostgreBackupWizardPageObjects.this.curSchema.getViews(monitor));
                        }
                        objects.sort(DBUtils.nameComparator());
                        UIUtils.syncExec(() -> {
                            PostgreBackupWizardPageObjects.this.tablesTable.removeAll();
                            for (PostgreTableBase table : objects) {
                                TableItem item = new TableItem(PostgreBackupWizardPageObjects.this.tablesTable, 0);
                                item.setImage(DBeaverIcons.getImage((DBPImage)(table.isView() ? DBIcon.TREE_VIEW : DBIcon.TREE_TABLE)));
                                item.setText(0, table.getName());
                                item.setData((Object)table);
                                item.setChecked(isCatalogChecked && (checkedObjects == null || checkedObjects.contains(table)));
                            }
                        });
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError("Table list", "Can't read table list", (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return objects;
    }

    public void saveState() {
        super.saveState();
        List objects = ((PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings()).getExportObjects();
        objects.clear();
        ArrayList<PostgreSchema> entireSchemas = new ArrayList<PostgreSchema>();
        TableItem[] tableItemArray = this.schemasTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                PostgreSchema schema = (PostgreSchema)item.getData();
                Set<PostgreTableBase> checkedTables = this.checkedObjects.get(schema);
                if (checkedTables == null) {
                    entireSchemas.add(schema);
                } else {
                    PostgreDatabaseBackupInfo info = new PostgreDatabaseBackupInfo(this.dataBase, Collections.singletonList(schema), new ArrayList<PostgreTableBase>(checkedTables));
                    objects.add(info);
                }
            }
            ++n2;
        }
        if (!entireSchemas.isEmpty()) {
            PostgreDatabaseBackupInfo info = new PostgreDatabaseBackupInfo(this.dataBase, entireSchemas, null);
            objects.add(info);
        }
    }

    private boolean isAllSchemaSelected() {
        TableItem[] tableItemArray = this.schemasTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!item.getChecked()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void updatefullSchemaBackupState() {
        boolean allSchemasSelected = this.isAllSchemaSelected();
        this.fullSchemaBackupCheck.setEnabled(allSchemasSelected);
        ((PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings()).setFullSchemaBackup(allSchemasSelected);
    }

    protected void updateState() {
        this.updatefullSchemaBackupState();
        this.updatePageCompletion();
        this.getContainer().updateButtons();
    }

    protected void updateTableCheckedStatus(@NotNull Table table, boolean check) {
        if (table == this.schemasTable) {
            TableItem[] items = this.tablesTable.getItems();
            if (items.length != 0) {
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(check);
                    ++n2;
                }
            } else {
                TableItem[] schemasItems = this.schemasTable.getItems();
                if (schemasItems.length != 0) {
                    TableItem[] tableItemArray = schemasItems;
                    int n = schemasItems.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableItem schemaItem = tableItemArray[n3];
                        Object data = schemaItem.getData();
                        if (data instanceof PostgreSchema) {
                            PostgreSchema postgreSchema = (PostgreSchema)data;
                            if (schemaItem.getChecked() && check && !this.checkedObjects.containsKey(postgreSchema)) {
                                List<PostgreTableBase> tableBaseList = this.loadTables(postgreSchema);
                                if (!CommonUtils.isEmpty(tableBaseList)) {
                                    this.checkedObjects.put(postgreSchema, new HashSet<PostgreTableBase>(tableBaseList));
                                }
                            } else if (!schemaItem.getChecked() && !check) {
                                this.checkedObjects.remove(postgreSchema);
                            }
                        }
                        ++n3;
                    }
                }
            }
        }
        this.updateCheckedTables();
    }
}

