/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.image;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.eclipse.jface.action.IContributionManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.controls.imageview.AbstractImageViewer;
import org.jkiss.dbeaver.ui.controls.imageview.BrowserImageViewer;
import org.jkiss.dbeaver.ui.controls.imageview.SWTImageViewer;
import org.jkiss.dbeaver.ui.data.IStreamValueEditorPersistent;
import org.jkiss.dbeaver.ui.data.IValueController;

public class ImagePanelEditor
implements IStreamValueEditorPersistent<AbstractImageViewer> {
    public AbstractImageViewer createControl(IValueController valueController) {
        DBPPreferenceStore preferenceStore;
        DBPPreferenceStore dBPPreferenceStore = preferenceStore = valueController.getExecutionContext() != null ? valueController.getExecutionContext().getDataSource().getContainer().getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
        if (preferenceStore.getBoolean("resultset.image.browser")) {
            return new BrowserImageViewer(valueController.getEditPlaceholder(), 0);
        }
        return new SWTImageViewer(valueController.getEditPlaceholder(), 0);
    }

    public void primeEditorValue(@NotNull DBRProgressMonitor monitor, final @Nullable AbstractImageViewer control, @NotNull DBDContent value) throws DBException {
        block13: {
            monitor.subTask("Read image value");
            DBDContentStorage data = value.getContents(monitor);
            if (data != null) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (final InputStream contentStream = data.getContentStream();){
                        if (!new UITask<Boolean>(){

                            protected Boolean runTask() {
                                if (control != null && !control.isDisposed()) {
                                    return control.loadImage(contentStream);
                                }
                                return true;
                            }
                        }.runTask().booleanValue()) {
                            // empty if block
                        }
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new DBException("Error reading stream value", (Throwable)e);
                }
            }
            control.clearImage();
        }
    }

    public void extractEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull AbstractImageViewer control, @NotNull DBDContent value) throws DBException {
    }

    public void contributeActions(@NotNull IContributionManager manager, @NotNull AbstractImageViewer control) throws DBCException {
        control.fillToolBar(manager);
    }

    public void contributeSettings(@NotNull IContributionManager manager, @NotNull AbstractImageViewer control) throws DBCException {
    }

    @Nullable
    public Path getExternalFilePath(@NotNull AbstractImageViewer control) {
        return control.getExternalFilePath();
    }
}

