/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class SQLEditorHandlerSeparateConnectionSwitch
extends CompoundContributionItem {
    @NotNull
    protected IContributionItem[] getContributionItems() {
        final DBPPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore == null) {
            Action placeholder = new Action(SQLEditorMessages.sql_editor_separate_connection_no_editor_or_ds_selected, 0){

                public void run() {
                }
            };
            placeholder.setEnabled(false);
            return new IContributionItem[]{new ActionContributionItem((IAction)placeholder)};
        }
        List<ModelPreferences.SeparateConnectionBehavior> behaviors = List.of(ModelPreferences.SeparateConnectionBehavior.ALWAYS, ModelPreferences.SeparateConnectionBehavior.DEFAULT, ModelPreferences.SeparateConnectionBehavior.NEVER);
        ModelPreferences.SeparateConnectionBehavior currValue = ModelPreferences.SeparateConnectionBehavior.parse((String)preferenceStore.getString("database.editor.separate.connection"));
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>(behaviors.size());
        for (final ModelPreferences.SeparateConnectionBehavior behavior : behaviors) {
            Action action = new Action(behavior.getTitle(), 8){

                public void run() {
                    preferenceStore.setValue("database.editor.separate.connection", behavior.name());
                    PrefUtils.savePreferenceStore((DBPPreferenceStore)preferenceStore);
                }
            };
            if (currValue.equals((Object)behavior)) {
                action.setChecked(true);
            }
            items.add(new ActionContributionItem((IAction)action));
        }
        return items.toArray(new IContributionItem[behaviors.size()]);
    }

    @Nullable
    private DBPPreferenceStore getPreferenceStore() {
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            ISelection selection;
            DBPDataSourceContainer dsContainer = AbstractDataSourceHandler.getDataSourceContainerFromPart((IWorkbenchPart)page.getActiveEditor());
            if (dsContainer != null) {
                return dsContainer.getPreferenceStore();
            }
            INavigatorModelView navigatorView = (INavigatorModelView)GeneralUtils.adapt((Object)page.getActivePart(), INavigatorModelView.class);
            if (navigatorView != null && (selection = navigatorView.getNavigatorViewer().getSelection()) != null) {
                DBPDataSource dataSource;
                DBSObject selectedObject = NavigatorUtils.getSelectedObject((ISelection)selection);
                if (selectedObject instanceof DBPDataSourceContainer) {
                    return ((DBPDataSourceContainer)selectedObject).getPreferenceStore();
                }
                if (selectedObject != null && (dataSource = selectedObject.getDataSource()) != null) {
                    return dataSource.getContainer().getPreferenceStore();
                }
            }
        }
        return null;
    }
}

