/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.log;

import java.io.PrintWriter;
import java.time.Instant;
import java.util.Date;
import org.eclipse.ui.internal.views.log.Group;
import org.eclipse.ui.internal.views.log.LogEntry;
import org.eclipse.ui.internal.views.log.Messages;

public class LogSession
extends Group {
    public static final String SESSION = "!SESSION";
    private String sessionData;
    private Date date;
    private String fDateString;

    public LogSession() {
        super(Messages.LogViewLabelProvider_Session);
    }

    public Date getDate() {
        return this.date;
    }

    public String getFormattedDate() {
        Date tmpdate;
        if (this.fDateString == null && (tmpdate = this.getDate()) != null) {
            this.fDateString = LogEntry.LOCAL_SDF.format(tmpdate.toInstant());
        }
        return this.fDateString;
    }

    public void setDate(String dateString) {
        try {
            Date parsed = Date.from(Instant.from(LogEntry.GREGORIAN_SDF.parse(dateString)));
            if (parsed != null) {
                this.date = parsed;
                this.fDateString = LogEntry.LOCAL_SDF.format(parsed.toInstant());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSessionData() {
        return this.sessionData;
    }

    void setSessionData(String data) {
        this.sessionData = data;
    }

    public void processLogLine(String line) {
        if (line.startsWith(SESSION)) {
            int delim = (line = line.substring(SESSION.length()).trim()).indexOf("----");
            if (delim == -1) {
                return;
            }
            String dateBuffer = line.substring(0, delim).trim();
            this.setDate(dateBuffer);
        }
    }

    @Override
    public void write(PrintWriter writer) {
        writer.write(this.sessionData);
        writer.println();
        super.write(writer);
    }
}

