/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import java.util.Locale;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.utils.CommonUtils;

public class SQLDelimiterRule
implements TPRule {
    private final TPToken token;
    private char[][] delimiters;
    private char[][] origDelimiters;
    private char[] buffer;
    private char[] origBuffer;

    public SQLDelimiterRule(String[] delimiters, TPToken token) {
        this.token = token;
        char[][] cArrayArray = new char[delimiters.length][];
        this.delimiters = cArrayArray;
        this.origDelimiters = cArrayArray;
        int index = 0;
        int maxLength = 0;
        String[] stringArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String delim = stringArray[n2];
            this.delimiters[index] = delim.toCharArray();
            int i = 0;
            while (i < this.delimiters[index].length) {
                this.delimiters[index][i] = Character.toUpperCase(this.delimiters[index][i]);
                ++i;
            }
            maxLength = Math.max(maxLength, this.delimiters[index].length);
            ++index;
            ++n2;
        }
        this.buffer = new char[maxLength];
        this.origBuffer = this.buffer;
    }

    public char[][] getDelimiters() {
        return this.delimiters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        int i = 0;
        while (true) {
            int k;
            int c = scanner.read();
            boolean matches = false;
            if (c != -1) {
                c = Character.toUpperCase(c);
                k = 0;
                while (k < this.delimiters.length) {
                    if (i < this.delimiters[k].length && this.delimiters[k][i] == c) {
                        this.buffer[i] = (char)c;
                        if (i == this.delimiters[k].length - 1 && this.equalsBegin(this.delimiters[k])) {
                            if (!Character.isLetterOrDigit(c)) return this.token;
                            int cn = scanner.read();
                            scanner.unread();
                            if (!Character.isUnicodeIdentifierPart(cn)) return this.token;
                            matches = false;
                        } else {
                            matches = true;
                            break;
                        }
                    }
                    ++k;
                }
            }
            if (!matches) {
                k = 0;
                while (k <= i) {
                    scanner.unread();
                    ++k;
                }
                return TPTokenAbstract.UNDEFINED;
            }
            ++i;
        }
    }

    private boolean equalsBegin(char[] delimiter) {
        int i = 0;
        while (i < delimiter.length) {
            if (this.buffer[i] != delimiter[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void changeDelimiter(String newDelimiter) {
        if (CommonUtils.isEmpty((String)newDelimiter)) {
            this.delimiters = this.origDelimiters;
            this.buffer = this.origBuffer;
        } else {
            char[][] cArray = this.delimiters;
            int n = this.delimiters.length;
            int n2 = 0;
            while (n2 < n) {
                char[] delim = cArray[n2];
                String delimStr = String.valueOf(delim);
                if (newDelimiter.equals(delimStr)) {
                    return;
                }
                if (newDelimiter.endsWith(delimStr)) {
                    newDelimiter = newDelimiter.substring(0, newDelimiter.length() - delimStr.length()).trim();
                }
                ++n2;
            }
            this.delimiters = new char[1][];
            this.delimiters[0] = newDelimiter.toUpperCase(Locale.ENGLISH).toCharArray();
            this.buffer = new char[newDelimiter.length()];
        }
    }
}

