/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstrainable;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt2;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.internal.ObjectEditorMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.ConstraintNameGenerator;
import org.jkiss.dbeaver.ui.editors.object.struct.PropertyObjectEditPage;
import org.jkiss.utils.CommonUtils;

public class EditAttributePage
extends PropertyObjectEditPage<DBSTableColumn> {
    @NotNull
    private final Map<String, Object> options;
    private boolean isUnique;
    private List<DBSEntityConstraintInfo> constraintTypes;
    private DBSEntityConstraintInfo selectedConstraintType;
    private final ConstraintNameGenerator constraintNameGenerator;
    private Combo keyTypeCombo;
    private Text constraintNameText;

    public EditAttributePage(@Nullable DBECommandContext commandContext, @NotNull DBSTableColumn object, @NotNull Map<String, Object> options) {
        super(commandContext, object);
        this.setTitle(NLS.bind((String)ObjectEditorMessages.dialog_struct_attribute_edit_page_header_edit_attribute, (Object)DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI)));
        this.options = options;
        this.constraintNameGenerator = new ConstraintNameGenerator(object.getParentObject());
    }

    @Override
    protected String getPropertiesGroupTitle() {
        return ObjectEditorMessages.dialog_struct_label_text_properties;
    }

    @Override
    protected void createAdditionalEditControls(Composite composite) {
        DBSEntity dBSEntity = ((DBSTableColumn)this.getObject()).getParentObject();
        if (dBSEntity instanceof DBSEntityConstrainable) {
            DBSEntityConstrainable ec = (DBSEntityConstrainable)dBSEntity;
            this.createKeysGroup(composite, ec);
        }
    }

    private void createKeysGroup(Composite composite, DBSEntityConstrainable attributeConstrainable) {
        this.constraintTypes = attributeConstrainable.getSupportedConstraints();
        if (CommonUtils.isEmpty(this.constraintTypes)) {
            return;
        }
        this.constraintTypes = this.constraintTypes.stream().filter(ct -> AbstractTableConstraint.class.isAssignableFrom(ct.getImplClass()) && ct.getType().isUnique()).collect(Collectors.toList());
        if (CommonUtils.isEmpty(this.constraintTypes)) {
            return;
        }
        Composite keysGroup = UIUtils.createTitledComposite((Composite)composite, (String)"Keys", (int)3, (int)768, (int)-1);
        Button uniqueCheck = UIUtils.createCheckbox((Composite)keysGroup, (String)"Unique", (String)"Mark column unique", (boolean)false, (int)1);
        this.keyTypeCombo = UIUtils.createLabelCombo((Composite)keysGroup, (String)"Type", (String)"Constraint type", (int)12);
        this.keyTypeCombo.setLayoutData((Object)new GridData(32));
        for (DBSEntityConstraintInfo ct2 : this.constraintTypes) {
            this.keyTypeCombo.add(ct2.getType().getLocalizedName());
        }
        this.keyTypeCombo.setEnabled(false);
        uniqueCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            this.isUnique = uniqueCheck.getSelection();
            this.keyTypeCombo.setEnabled(this.isUnique);
            this.constraintNameText.setEnabled(this.isUnique);
            if (this.isUnique && this.keyTypeCombo.getSelectionIndex() < 0) {
                this.keyTypeCombo.select(0);
            }
            this.updateConstraintType();
        }));
        this.keyTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAttributePage.this.updateConstraintType();
            }
        });
        UIUtils.createEmptyLabel((Composite)keysGroup, (int)1, (int)1);
        GridData gd = new GridData(32);
        gd.widthHint = 150;
        this.constraintNameText = UIUtils.createLabelText((Composite)keysGroup, (String)"Name", null, (int)2048, (Object)gd);
        this.constraintNameText.addModifyListener(e -> this.constraintNameGenerator.setConstraintName(this.constraintNameText.getText()));
    }

    private void updateConstraintType() {
        int selectionIndex = this.keyTypeCombo.getSelectionIndex();
        if (!this.isUnique || selectionIndex < 0) {
            this.selectedConstraintType = null;
        } else {
            this.selectedConstraintType = this.constraintTypes.get(selectionIndex);
            this.constraintNameGenerator.setConstraintType(this.selectedConstraintType.getType());
            this.constraintNameText.setText(this.constraintNameGenerator.getConstraintName());
        }
        this.validateProperties();
    }

    @Override
    protected String getEditError() {
        if (this.isUnique) {
            if (this.selectedConstraintType == null) {
                return "You must choose constraint type";
            }
            String error = this.constraintNameGenerator.validateAllowedType(this.selectedConstraintType.getType());
            if (error != null) {
                return error;
            }
        }
        return super.getEditError();
    }

    @Override
    public void performFinish() throws DBException {
        super.performFinish();
        if (this.isUnique && this.selectedConstraintType != null) {
            this.options.put("additional.actions", monitor -> {
                try {
                    this.createConstrainForColumn(monitor);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
    }

    private void createConstrainForColumn(DBRProgressMonitor monitor) throws DBException {
        DBSObject newConstraint;
        DBECommandContext commandContext = this.getCommandContext();
        DBEObjectManager objectManager = DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(this.selectedConstraintType.getImplClass());
        if (objectManager == null) {
            throw new DBException("Object manager not found for type '" + this.selectedConstraintType.getImplClass().getName() + "'");
        }
        DBEObjectMaker objectMaker = (DBEObjectMaker)objectManager;
        LinkedHashMap<String, Object> constrOptions = new LinkedHashMap<String, Object>(this.options);
        constrOptions.put("skip.object.configuration", true);
        DBSTableColumn column = (DBSTableColumn)this.getObject();
        if (column instanceof DBSTypedObjectExt2) {
            DBSTypedObjectExt2 to2 = (DBSTypedObjectExt2)column;
            to2.setRequired(true);
        }
        if ((newConstraint = objectMaker.createNewObject(monitor, commandContext, (Object)column.getParentObject(), null, constrOptions)) instanceof AbstractTableConstraint) {
            AbstractTableConstraint atc = (AbstractTableConstraint)newConstraint;
            atc.setName(this.constraintNameGenerator.getConstraintName());
            atc.setConstraintType(this.selectedConstraintType.getType());
            atc.addAttributeReference(column);
        }
    }
}

