/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.scripts;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.file.IFileTypeHandler;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;

public class SQLFileHandler
implements IFileTypeHandler {
    public void openFiles(@NotNull List<Path> fileList, @NotNull Map<String, String> parameters, @Nullable DBPDataSourceContainer dataSource) {
        for (Path path : fileList) {
            File file = path.toFile();
            if (dataSource != null) {
                EditorUtils.setFileDataSource((File)file, (DatabaseEditorContext)new SQLNavigatorContext((DBSObject)dataSource));
            }
            EditorUtils.openExternalFileEditor((File)file, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
        }
    }

    public void importFiles(@NotNull List<Path> filePath, @Nullable String extension) throws DBException {
        throw new DBException("Importing files is not supported for SQL files");
    }
}

