/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPSystemInfoObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreSetting
implements DBSObject,
DBPSystemInfoObject {
    private final PostgreDataSource database;
    private final String name;
    private final String value;
    private final String unit;
    private final String description;

    protected PostgreSetting(PostgreDataSource database, ResultSet dbResult) {
        this.database = database;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.value = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"setting");
        this.unit = database.isServerVersionAtLeast(8, 2) ? JDBCUtils.safeGetString((ResultSet)dbResult, (String)"unit") : null;
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"short_desc");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    @Nullable
    public String getValue() {
        return this.value;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getUnit() {
        return this.unit;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.database;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.database.getDataSource();
    }
}

