/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.registry;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferNodeConfiguratorDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageDescriptor;

public class DataTransferConfiguratorRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataTransferConfigurator";
    private static DataTransferConfiguratorRegistry instance = null;
    private static final Log log = Log.getLog(DataTransferConfiguratorRegistry.class);
    private Map<String, DataTransferNodeConfiguratorDescriptor> nodeConfigurators = new LinkedHashMap<String, DataTransferNodeConfiguratorDescriptor>();

    public static synchronized DataTransferConfiguratorRegistry getInstance() {
        if (instance == null) {
            instance = new DataTransferConfiguratorRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataTransferConfiguratorRegistry(IExtensionRegistry registry) {
        HashMap pagesById = new HashMap();
        ArrayList replacements = new ArrayList();
        Arrays.stream(registry.getConfigurationElementsFor(EXTENSION_ID)).filter(it -> "configPages".equals(it.getName())).forEach(it -> {
            String nodeId = it.getAttribute("node");
            String replaces = it.getAttribute("replaces");
            DataTransferNodeConfiguratorDescriptor descriptor = new DataTransferNodeConfiguratorDescriptor((IConfigurationElement)it);
            if (pagesById.containsKey(nodeId)) {
                throw new IllegalArgumentException("Duplicate node id: " + nodeId);
            }
            pagesById.put(nodeId, descriptor);
            if (replaces != null && !replaces.isEmpty()) {
                replacements.add(new AbstractMap.SimpleEntry<String, DataTransferNodeConfiguratorDescriptor>(replaces, descriptor));
            }
        });
        replacements.forEach(replacement -> {
            pagesById.remove(((DataTransferNodeConfiguratorDescriptor)((Object)((Object)replacement.getValue()))).getId());
            DataTransferNodeConfiguratorDescriptor replaced = pagesById.put((String)replacement.getKey(), (DataTransferNodeConfiguratorDescriptor)((Object)((Object)replacement.getValue())));
            if (replaced != null) {
                log.debug((Object)("Data transfer configurator '" + replaced.getId() + "' is replaced by '" + ((DataTransferNodeConfiguratorDescriptor)((Object)((Object)replacement.getValue()))).getId() + "'"));
            } else {
                log.debug((Object)("No configurator with id '" + (String)replacement.getKey() + "' found to replace, adding new one: " + ((DataTransferNodeConfiguratorDescriptor)((Object)((Object)replacement.getValue()))).getId()));
            }
        });
        this.nodeConfigurators.putAll(pagesById);
    }

    public DataTransferNodeConfiguratorDescriptor getConfigurator(String nodeId) {
        return this.nodeConfigurators.get(nodeId);
    }

    public DataTransferPageDescriptor getPageDescriptor(IWizardPage page) {
        for (DataTransferNodeConfiguratorDescriptor nd : this.nodeConfigurators.values()) {
            for (DataTransferPageDescriptor pd : nd.patPageDescriptors()) {
                if (!pd.getPageClass().getImplName().equals(page.getClass().getName())) continue;
                return pd;
            }
        }
        return null;
    }
}

