/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.sql.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.model.rm.RMControllerProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.model.sql.exec.SQLScriptProcessor;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.model.task.DBTaskUtils;
import org.jkiss.dbeaver.tools.sql.SQLScriptExecuteSettings;
import org.jkiss.dbeaver.tools.sql.task.SQLScriptDataReceiver;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.utils.IOUtils;

public class SQLScriptExecuteHandler
implements DBTTaskHandler {
    private final DBCStatistics totalStatistics = new DBCStatistics();

    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        SQLScriptExecuteSettings settings = new SQLScriptExecuteSettings();
        settings.loadConfiguration(task);
        this.executeWithSettings(runnableContext, task, locale, log, logStream, listener, settings);
        return DBTTaskRunStatus.makeStatisticsStatus((DBCStatistics)this.totalStatistics);
    }

    private void executeWithSettings(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener, @NotNull SQLScriptExecuteSettings settings) throws DBException {
        log.debug((Object)"SQL Scripts Execute");
        listener.taskStarted(task);
        Throwable error = null;
        try {
            runnableContext.run(true, true, monitor -> {
                try {
                    this.runScripts(monitor, task, settings, log, logStream);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException interruptedException) {
            log.debug((Object)"Task canceled");
        }
        if (error != null) {
            log.error((Object)error);
        }
        listener.taskFinished(task, null, error, (Object)settings);
        log.debug((Object)"SQL script execute completed");
    }

    private void runScripts(DBRProgressMonitor monitor, DBTTask task, SQLScriptExecuteSettings settings, Log log, PrintStream logStream) throws DBException {
        List<DBPDataSourceContainer> dataSources = settings.getDataSources();
        for (String filePath : settings.getScriptFiles()) {
            try {
                for (DBPDataSourceContainer dataSourceContainer : dataSources) {
                    DBPDataSource dataSource;
                    String sqlScriptContent = SQLScriptExecuteHandler.readScriptContents(monitor, task.getProject(), filePath);
                    if (!dataSourceContainer.isConnected()) {
                        dataSourceContainer.connect(monitor, true, true);
                    }
                    if ((dataSource = dataSourceContainer.getDataSource()) == null) {
                        throw new DBException("Can't obtain data source connection");
                    }
                    DBCExecutionContext executionContext = dataSource.getDefaultInstance().getDefaultContext(monitor, false);
                    log.debug((Object)("> Execute script [" + filePath + "] in [" + dataSourceContainer.getName() + "]"));
                    DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
                    if (contextDefaults != null) {
                        DBSSchema defaultSchema;
                        DBSCatalog defaultCatalog = contextDefaults.getDefaultCatalog();
                        if (defaultCatalog != null) {
                            log.debug((Object)("> Default catalog: " + defaultCatalog.getName()));
                        }
                        if ((defaultSchema = contextDefaults.getDefaultSchema()) != null) {
                            log.debug((Object)("> Default schema: " + defaultSchema.getName()));
                        }
                    }
                    this.processScript(monitor, task, settings, executionContext, filePath, sqlScriptContent, log, logStream);
                }
            }
            catch (Throwable e) {
                Throwable error = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                throw new DBException("Error executing script '" + filePath + "'", error);
            }
        }
    }

    private void processScript(DBRProgressMonitor monitor, DBTTask task, SQLScriptExecuteSettings settings, DBCExecutionContext executionContext, String filePath, String sqlScriptContent, Log log, PrintStream logStream) throws DBException {
        PrintWriter logWriter = new PrintWriter(logStream, true);
        List scriptElements = SQLScriptParser.parseScript((DBPDataSource)executionContext.getDataSource(), (String)sqlScriptContent);
        SQLScriptContext scriptContext = new SQLScriptContext(null, () -> executionContext, null, (Writer)logWriter, null);
        scriptContext.setVariables(DBTaskUtils.getVariables((DBTTask)task));
        SQLScriptDataReceiver dataReceiver = new SQLScriptDataReceiver();
        SQLScriptProcessor scriptProcessor = new SQLScriptProcessor(executionContext, scriptElements, scriptContext, (DBDDataReceiver)dataReceiver, log);
        scriptProcessor.setCommitType(settings.isAutoCommit() ? SQLScriptCommitType.AUTOCOMMIT : SQLScriptCommitType.AT_END);
        scriptProcessor.setErrorHandling(settings.isIgnoreErrors() ? SQLScriptErrorHandling.IGNORE : SQLScriptErrorHandling.STOP_ROLLBACK);
        if (settings.isDumpQueryResultsToLog()) {
            dataReceiver.setDumpWriter(logWriter);
        }
        scriptProcessor.runScript(monitor);
        this.totalStatistics.accumulate(scriptProcessor.getTotalStatistics());
    }

    public static String readScriptContents(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull String filePath) throws DBException, IOException {
        Path nioPath = DBFUtils.resolvePathFromString((DBRProgressMonitor)monitor, (DBPProject)project, (String)filePath);
        if (!IOUtils.isLocalPath((Path)nioPath)) {
            return Files.readString(nioPath);
        }
        RMControllerProvider rmControllerProvider = (RMControllerProvider)DBUtils.getAdapter(RMControllerProvider.class, (Object)project);
        if (rmControllerProvider != null) {
            RMController rmController = rmControllerProvider.getResourceController();
            return new String(rmController.getResourceContents(project.getId(), filePath), StandardCharsets.UTF_8);
        }
        Path sqlFile = DTUtils.findProjectFile(project, filePath);
        if (sqlFile == null) {
            throw new DBException("File " + filePath + " is not found in project " + project.getId());
        }
        Throwable throwable = null;
        Object var7_9 = null;
        try (BufferedReader fileReader = Files.newBufferedReader(sqlFile);){
            return IOUtils.readToString((Reader)fileReader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

