/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.notifications.NotificationSettings;
import org.jkiss.dbeaver.ui.notifications.NotificationUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.registry.NotificationDescriptor;
import org.jkiss.dbeaver.ui.registry.NotificationRegistry;

public class PrefPageNotifications
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    private static final String SOUND_BEEP_LABEL = "System beep";
    private static final String SOUND_NONE_LABEL = "No sound";
    private static final String SOUND_FILE_LABEL = "Choose file...";
    private final Map<NotificationDescriptor, NotificationSettings> settings = new HashMap<NotificationDescriptor, NotificationSettings>();
    private TableViewer viewer;
    private Button enablePopupsCheckbox;
    private Spinner hideDelaySpinner;
    private Button enableSoundsCheckbox;
    private Spinner soundVolumeSpinner;
    private Button longOperationsCheck;
    private Spinner longOperationsTimeout;

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        Composite group = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_notifications_group_global, (int)2, (int)768);
        this.enablePopupsCheckbox = UIUtils.createCheckbox((Composite)group, (String)CoreMessages.pref_page_notifications_enable_notifications_label, (String)CoreMessages.pref_page_notifications_enable_notifications_label_tip, (boolean)preferences.getBoolean("notifications.enabled"), (int)2);
        this.hideDelaySpinner = UIUtils.createLabelSpinner((Composite)group, (String)CoreMessages.pref_page_notifications_label_notifications_close_delay, (int)preferences.getInt("notifications.closeDelay"), (int)0, (int)Integer.MAX_VALUE);
        this.enableSoundsCheckbox = UIUtils.createCheckbox((Composite)group, (String)CoreMessages.pref_page_notifications_enable_sounds_label, null, (boolean)preferences.getBoolean("notifications.soundEnabled"), (int)2);
        this.soundVolumeSpinner = UIUtils.createLabelSpinner((Composite)group, (String)CoreMessages.pref_page_notifications_sound_volume_label, (int)preferences.getInt("notifications.soundVolume"), (int)1, (int)100);
        this.longOperationsCheck = UIUtils.createCheckbox((Composite)group, (String)CoreMessages.pref_page_ui_general_label_enable_long_operations, (String)CoreMessages.pref_page_ui_general_label_enable_long_operations_tip, (boolean)preferences.getBoolean("agent.long.operation.notify"), (int)2);
        this.longOperationsTimeout = UIUtils.createLabelSpinner((Composite)group, (String)(CoreMessages.pref_page_ui_general_label_long_operation_timeout + UIMessages.label_sec), (int)preferences.getInt("agent.long.operation.timeout"), (int)0, (int)Integer.MAX_VALUE);
        this.viewer = new TableViewer(composite, 67588);
        this.viewer.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(600, -1).create());
        this.viewer.getTable().setHeaderVisible(true);
        ViewerColumnController controller = new ViewerColumnController("PrefPageNotifications", (ColumnViewer)this.viewer);
        controller.addColumn(CoreMessages.pref_page_notifications_column_name_label, null, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((NotificationDescriptor)element).getName();
            }

            public String getToolTipText(Object element) {
                return ((NotificationDescriptor)element).getDescription();
            }
        });
        controller.addColumn(CoreMessages.pref_page_notifications_column_sound_label, null, 16384, true, true, element -> {
            NotificationSettings settings = this.getSettings((NotificationDescriptor)element);
            if (!settings.isPlaySound()) {
                return SOUND_NONE_LABEL;
            }
            if (settings.getSoundFile() == null) {
                return SOUND_BEEP_LABEL;
            }
            return settings.getSoundFile().toString();
        }, new EditingSupport((ColumnViewer)this.viewer){

            protected CellEditor getCellEditor(Object element) {
                ArrayList<String> choices = new ArrayList<String>();
                choices.add(PrefPageNotifications.SOUND_BEEP_LABEL);
                choices.add(PrefPageNotifications.SOUND_NONE_LABEL);
                choices.add(PrefPageNotifications.SOUND_FILE_LABEL);
                return new CustomComboBoxCellEditor((ColumnViewer)PrefPageNotifications.this.viewer, (Composite)PrefPageNotifications.this.viewer.getTable(), choices.toArray(new String[0]), 12);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                NotificationSettings settings = PrefPageNotifications.this.getSettings((NotificationDescriptor)element);
                if (!settings.isPlaySound()) {
                    return PrefPageNotifications.SOUND_NONE_LABEL;
                }
                if (settings.getSoundFile() == null) {
                    return PrefPageNotifications.SOUND_BEEP_LABEL;
                }
                return settings.getSoundFile().toString();
            }

            protected void setValue(Object element, Object value) {
                NotificationSettings settings = PrefPageNotifications.this.getSettings((NotificationDescriptor)element);
                switch ((String)value) {
                    case "System beep": {
                        settings.setPlaySound(true);
                        settings.setSoundFile(null);
                        break;
                    }
                    case "No sound": {
                        settings.setPlaySound(false);
                        settings.setSoundFile(null);
                        break;
                    }
                    case "Choose file...": {
                        FileDialog dialog = new FileDialog(PrefPageNotifications.this.getShell(), 4096);
                        dialog.setText("Choose notification sound file");
                        dialog.setFilterExtensions(new String[]{"*.wav"});
                        dialog.setFilterNames(new String[]{"Waveform Audio File"});
                        if (dialog.open() == null) break;
                        settings.setPlaySound(true);
                        settings.setSoundFile(new File(dialog.getFilterPath(), dialog.getFileName()));
                    }
                }
                PrefPageNotifications.this.viewer.refresh();
            }
        });
        controller.addBooleanColumn(CoreMessages.pref_page_notifications_column_popup_label, null, 0x1000000, true, true, element -> this.getSettings((NotificationDescriptor)element).isShowPopup(), new EditingSupport((ColumnViewer)this.viewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)PrefPageNotifications.this.viewer.getTable(), true);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return PrefPageNotifications.this.getSettings((NotificationDescriptor)element).isShowPopup();
            }

            protected void setValue(Object element, Object value) {
                PrefPageNotifications.this.getSettings((NotificationDescriptor)element).setShowPopup(((Boolean)value).booleanValue());
            }
        });
        controller.createColumns(false);
        controller.sortByColumn(0, 128);
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.viewer.setInput(NotificationRegistry.getInstance().getNotifications().stream().filter(descriptor -> !descriptor.isHidden()).collect(Collectors.toList()));
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.viewer.getTable(), (boolean)true));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        return composite;
    }

    public boolean performOk() {
        for (Map.Entry<NotificationDescriptor, NotificationSettings> entry : this.settings.entrySet()) {
            NotificationUtils.setNotificationSettings((String)entry.getKey().getId(), (NotificationSettings)entry.getValue());
        }
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        preferences.setValue("notifications.enabled", this.enablePopupsCheckbox.getSelection());
        preferences.setValue("notifications.closeDelay", this.hideDelaySpinner.getSelection());
        preferences.setValue("notifications.soundEnabled", this.enableSoundsCheckbox.getSelection());
        preferences.setValue("notifications.soundVolume", this.soundVolumeSpinner.getSelection());
        preferences.setValue("agent.long.operation.notify", this.longOperationsCheck.getSelection());
        preferences.setValue("agent.long.operation.timeout", this.longOperationsTimeout.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        for (Map.Entry<NotificationDescriptor, NotificationSettings> entry : this.settings.entrySet()) {
            NotificationDescriptor descriptor = entry.getKey();
            NotificationSettings settings = entry.getValue();
            settings.setShowPopup(true);
            settings.setPlaySound(descriptor.isSoundEnabled());
            settings.setSoundFile(null);
        }
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        this.enablePopupsCheckbox.setSelection(preferences.getDefaultBoolean("notifications.enabled"));
        this.hideDelaySpinner.setSelection(preferences.getDefaultInt("notifications.closeDelay"));
        this.enableSoundsCheckbox.setSelection(preferences.getDefaultBoolean("notifications.soundEnabled"));
        this.soundVolumeSpinner.setSelection(preferences.getDefaultInt("notifications.soundVolume"));
        this.longOperationsCheck.setSelection(preferences.getDefaultBoolean("agent.long.operation.notify"));
        this.longOperationsTimeout.setSelection(preferences.getDefaultInt("agent.long.operation.timeout"));
        this.viewer.refresh();
        super.performDefaults();
    }

    @NotNull
    private NotificationSettings getSettings(@NotNull NotificationDescriptor descriptor) {
        return this.settings.computeIfAbsent(descriptor, d -> NotificationUtils.getNotificationSettings((String)d.getId()));
    }
}

