/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridServer;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class CubridServerManager
extends SQLObjectEditor<CubridServer, GenericStructContainer>
implements DBEObjectRenamer<CubridServer> {
    public static final String BASE_SERVER_NAME = "new_server";

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    public DBSObjectCache<? extends DBSObject, CubridServer> getObjectsCache(CubridServer object) {
        DBSObject parentObject = object.getParentObject();
        if (parentObject instanceof CubridDataSource) {
            CubridDataSource container = (CubridDataSource)parentObject;
            return container.getServerCache();
        }
        return null;
    }

    protected CubridServer createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @Nullable Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) {
        return new CubridServer((CubridDataSource)((Object)container), BASE_SERVER_NAME);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        CubridServer server = (CubridServer)command.getObject();
        StringBuilder query = new StringBuilder();
        query.append("CREATE SERVER ");
        query.append(DBUtils.getQuotedIdentifier((DBSObject)server.getOwner()) + "." + DBUtils.getFullQualifiedName((DBPDataSource)server.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{server}));
        query.append(" (HOST=").append(SQLUtils.quoteString((DBSObject)server, (String)server.getHost()));
        if (server.getPort() != null) {
            query.append(", PORT=").append(server.getPort());
        }
        if (server.getDbName() != null) {
            query.append(", DBNAME=").append(server.getDbName());
        }
        this.additionalCreateActions(server, query);
        query.append(")");
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Server", query.toString()));
    }

    public void additionalCreateActions(@NotNull CubridServer server, @NotNull StringBuilder query) {
        if (server.getUserName() != null) {
            query.append(", USER=").append(server.getUserName());
        }
        if (server.getPassword() != null) {
            query.append(", PASSWORD=").append(SQLUtils.quoteString((DBSObject)server, (String)server.getPassword()));
        }
        if (server.getProperties() != null) {
            query.append(", PROPERTIES=").append(SQLUtils.quoteString((DBSObject)server, (String)server.getProperties()));
        }
        if (server.getDescription() != null) {
            query.append(", COMMENT=").append(SQLUtils.quoteString((DBSObject)server, (String)server.getDescription()));
        }
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        CubridServer server = (CubridServer)command.getObject();
        String suffix = ",";
        StringBuilder query = new StringBuilder();
        query.append("ALTER SERVER ");
        query.append(DBUtils.getQuotedIdentifier((DBSObject)server.getOwner()) + "." + DBUtils.getFullQualifiedName((DBPDataSource)server.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{server}));
        if (command.getProperty((Object)"host") != null && server.getHost() != null) {
            query.append(" CHANGE HOST=").append(SQLUtils.quoteString((DBSObject)server, (String)server.getHost())).append(suffix);
        }
        if (command.getProperty((Object)"port") != null && server.getPort() != null) {
            query.append(" CHANGE PORT=").append(server.getPort()).append(suffix);
        }
        if (command.getProperty((Object)"dbName") != null && server.getDbName() != null) {
            query.append(" CHANGE DBNAME=").append(server.getDbName()).append(suffix);
        }
        this.additionalModifyActions(server, query, command, suffix);
        query.deleteCharAt(query.length() - 1);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter Server", query.toString()));
    }

    public void additionalModifyActions(@NotNull CubridServer server, @NotNull StringBuilder query, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull String suffix) {
        if (command.getProperty((Object)"userName") != null && server.getUserName() != null) {
            query.append(" CHANGE USER=").append(server.getUserName()).append(suffix);
        }
        if (command.getProperty((Object)"password") != null && server.getPassword() != null) {
            query.append(" CHANGE PASSWORD=").append(SQLUtils.quoteString((DBSObject)server, (String)server.getPassword())).append(suffix);
        }
        if (command.hasProperty((Object)"properties") || server.getProperties() != null) {
            query.append(" CHANGE PROPERTIES=").append(SQLUtils.quoteString((DBSObject)server, (String)CommonUtils.notEmpty((String)server.getProperties()))).append(suffix);
        }
        if (command.hasProperty((Object)"description") || server.getDescription() != null) {
            query.append(" CHANGE COMMENT=").append(SQLUtils.quoteString((DBSObject)server, (String)CommonUtils.notEmpty((String)server.getDescription()))).append(suffix);
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        CubridServer server = (CubridServer)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop Server", "DROP SERVER " + DBUtils.getQuotedIdentifier((DBSObject)server.getOwner()) + "." + DBUtils.getFullQualifiedName((DBPDataSource)server.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{server})));
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        CubridServer server = (CubridServer)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename Server", "RENAME SERVER " + DBUtils.getQuotedIdentifier((DBSObject)server.getOwner()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)server.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)server.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull CubridServer object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        if (!object.getDataSource().isShard()) {
            this.processObjectRename(commandContext, object, options, newName);
        }
    }

    public boolean canCreateObject(@NotNull Object container) {
        return !((CubridDataSource)((Object)container)).isShard();
    }

    public boolean canEditObject(CubridServer object) {
        return !object.getDataSource().isShard();
    }

    public boolean canDeleteObject(CubridServer object) {
        return !object.getDataSource().isShard();
    }

    public boolean canRenameObject(CubridServer object) {
        return !object.getDataSource().isShard();
    }
}

