/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.swt.widgets.Display;

public class DisplayRealm
extends Realm {
    private static List<DisplayRealm> realms = new ArrayList<DisplayRealm>();
    private final Display display;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm getRealm(Display display) {
        List<DisplayRealm> list = realms;
        synchronized (list) {
            for (DisplayRealm element : realms) {
                if (element.display != display) continue;
                return element;
            }
            DisplayRealm result = new DisplayRealm(display);
            realms.add(result);
            return result;
        }
    }

    private DisplayRealm(Display display) {
        this.display = display;
    }

    public boolean isCurrent() {
        return Display.getCurrent() == this.display;
    }

    public void asyncExec(Runnable runnable) {
        Runnable safeRunnable = () -> DisplayRealm.safeRun((Runnable)runnable);
        if (!this.display.isDisposed()) {
            this.display.asyncExec(safeRunnable);
        }
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        if (!this.display.isDisposed()) {
            Runnable safeRunnable = () -> DisplayRealm.safeRun((Runnable)runnable);
            this.display.timerExec(milliseconds, safeRunnable);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.display);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DisplayRealm other = (DisplayRealm)((Object)obj);
        return Objects.equals(this.display, other.display);
    }
}

