/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.LocalHistoryPageSource;
import org.eclipse.team.internal.ui.history.ShowLocalHistory;
import org.eclipse.team.ui.history.HistoryPageCompareEditorInput;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.part.IPage;

public class ReplaceLocalHistory
extends ShowLocalHistory {
    @Override
    public void run(IAction action) {
        IFile file = (IFile)this.getSelection().getFirstElement();
        IFileState[] states = this.getLocalHistory();
        if (states == null || states.length == 0) {
            return;
        }
        Runnable r = () -> this.showCompareInDialog(this.getShell(), file);
        TeamUIPlugin.getStandardDisplay().asyncExec(r);
    }

    private void showCompareInDialog(Shell shell, Object object) {
        IHistoryPageSource pageSource = LocalHistoryPageSource.getInstance();
        if (pageSource != null && pageSource.canShowHistoryFor(object)) {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(false);
            cc.setRightEditable(false);
            HistoryPageCompareEditorInput input = new HistoryPageCompareEditorInput(cc, pageSource, object){

                @Override
                public boolean isEditionSelectionDialog() {
                    return true;
                }

                @Override
                public String getOKButtonLabel() {
                    return TeamUIMessages.ReplaceLocalHistory_0;
                }

                @Override
                protected IPage createPage(CompareViewerPane parent, IToolBarManager toolBarManager) {
                    IPage page = super.createPage(parent, toolBarManager, false);
                    Tree tree = this.getTree(page);
                    this.runDefaultSelectionEventOnSelectionChange(tree);
                    return page;
                }

                private void runDefaultSelectionEventOnSelectionChange(Tree tree) {
                    if (tree == null) {
                        return;
                    }
                    NotifyDefaultSelectionOnWidgetSelectedHandler handler = new NotifyDefaultSelectionOnWidgetSelectedHandler(tree);
                    tree.addSelectionListener((SelectionListener)handler);
                    tree.addMouseListener((MouseListener)handler);
                }

                /*
                 * WARNING - void declaration
                 */
                private Tree getTree(IPage page) {
                    void composite;
                    Control control = page.getControl();
                    if (!(control instanceof Composite)) {
                        return null;
                    }
                    Composite composite2 = (Composite)control;
                    Control[] children = composite.getChildren();
                    if (children == null) {
                        return null;
                    }
                    Control[] controlArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        if (child instanceof Tree) {
                            Tree t = (Tree)child;
                            return t;
                        }
                        ++n2;
                    }
                    return null;
                }

                @Override
                public boolean okPressed() {
                    try {
                        Object o = this.getSelectedEdition();
                        FileRevisionTypedElement right = (FileRevisionTypedElement)((ICompareInput)o).getRight();
                        IFile file = (IFile)this.getCompareResult();
                        file.setContents(right.getContents(), false, true, null);
                    }
                    catch (CoreException e) {
                        Utils.handle(e);
                        return false;
                    }
                    return true;
                }
            };
            CompareUI.openCompareDialog((CompareEditorInput)input);
        }
    }

    @Override
    protected String getPromptTitle() {
        return TeamUIMessages.ReplaceLocalHistory_1;
    }

    private static final class NotifyDefaultSelectionOnWidgetSelectedHandler
    extends SelectionAdapter
    implements MouseListener {
        private boolean mouseDownPressed = false;
        private Runnable runOnMouseUp;
        private final Tree tree;

        public NotifyDefaultSelectionOnWidgetSelectedHandler(Tree tree) {
            this.tree = tree;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.tree.getSelectionCount() != 1) {
                return;
            }
            Runnable r = () -> {
                Event event = new Event();
                event.item = selectionEvent.item;
                this.tree.notifyListeners(14, event);
            };
            if (this.mouseDownPressed) {
                this.runOnMouseUp = r;
                return;
            }
            r.run();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.mouseDownPressed = true;
        }

        public void mouseUp(MouseEvent e) {
            this.mouseDownPressed = false;
            if (this.runOnMouseUp != null) {
                this.runOnMouseUp.run();
                this.runOnMouseUp = null;
            }
        }
    }
}

