/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import java.time.Duration;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class PeriodicJob
extends AbstractJob {
    private static final Log log = Log.getLog(PeriodicJob.class);
    @NotNull
    protected final DBPPlatform platform;
    private final Duration period;

    public PeriodicJob(@NotNull String name, @NotNull DBPPlatform platform, @NotNull Duration period) {
        super(name);
        this.platform = platform;
        this.period = period;
        this.setUser(false);
        this.setSystem(true);
    }

    @Override
    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        if (this.platform.isShuttingDown()) {
            return Status.OK_STATUS;
        }
        log.trace(this.getName() + " job started");
        this.doJob(monitor);
        log.trace(this.getName() + " job finished");
        if (!this.platform.isShuttingDown()) {
            this.scheduleMonitor();
        }
        return Status.OK_STATUS;
    }

    protected abstract void doJob(@NotNull DBRProgressMonitor var1);

    public final void scheduleMonitor() {
        this.schedule(this.period);
    }
}

