/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.jkiss.utils.BeanUtils;

public class OracleXMLWrapper
implements SQLXML {
    private final Object xmlType;

    public OracleXMLWrapper(Object xmlType) {
        this.xmlType = xmlType;
    }

    @Override
    public void free() throws SQLException {
        try {
            BeanUtils.invokeObjectMethod((Object)this.xmlType, (String)"close", null, null);
        }
        catch (Throwable e) {
            throw new SQLException("Can't close XMLType", e);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            return (InputStream)BeanUtils.invokeObjectMethod((Object)this.xmlType, (String)"getInputStream", null, null);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new SQLException(e);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        throw new SQLException("Function not supported");
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            Object clobVal = BeanUtils.invokeObjectMethod((Object)this.xmlType, (String)"getClobVal", null, null);
            return (Reader)BeanUtils.invokeObjectMethod((Object)clobVal, (String)"getCharacterStream", null, null);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new SQLException(e);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        throw new SQLException("Function not supported");
    }

    @Override
    public String getString() throws SQLException {
        try {
            return (String)BeanUtils.invokeObjectMethod((Object)this.xmlType, (String)"getStringVal", null, null);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new SQLException(e);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        throw new SQLException("Function not supported");
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        return null;
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        throw new SQLException("Function not supported");
    }
}

