/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class ArrayExpression
extends ASTNodeAccessImpl
implements Expression {
    private Expression objExpression;
    private Expression indexExpression;
    private Expression startIndexExpression;
    private Expression stopIndexExpression;

    public ArrayExpression() {
    }

    public ArrayExpression(Expression objExpression, Expression indexExpression, Expression startIndexExpression, Expression stopIndexExpression) {
        this.objExpression = objExpression;
        this.indexExpression = indexExpression;
        this.startIndexExpression = startIndexExpression;
        this.stopIndexExpression = stopIndexExpression;
    }

    public ArrayExpression(Expression objExpression, Expression indexExpression) {
        this(objExpression, indexExpression, null, null);
    }

    public ArrayExpression(Expression objExpression, Expression startIndexExpression, Expression stopIndexExpression) {
        this(objExpression, null, startIndexExpression, stopIndexExpression);
    }

    public Expression getObjExpression() {
        return this.objExpression;
    }

    public void setObjExpression(Expression objExpression) {
        this.objExpression = objExpression;
    }

    public Expression getIndexExpression() {
        return this.indexExpression;
    }

    public void setIndexExpression(Expression indexExpression) {
        this.indexExpression = indexExpression;
    }

    public Expression getStartIndexExpression() {
        return this.startIndexExpression;
    }

    public void setStartIndexExpression(Expression startIndexExpression) {
        this.startIndexExpression = startIndexExpression;
    }

    public Expression getStopIndexExpression() {
        return this.stopIndexExpression;
    }

    public void setStopIndexExpression(Expression stopIndexExpression) {
        this.stopIndexExpression = stopIndexExpression;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    @Override
    public String toString() {
        if (this.indexExpression != null) {
            return this.objExpression.toString() + "[" + this.indexExpression.toString() + "]";
        }
        return this.objExpression.toString() + "[" + (this.startIndexExpression == null ? "" : this.startIndexExpression.toString()) + ":" + (this.stopIndexExpression == null ? "" : this.stopIndexExpression.toString()) + "]";
    }

    public ArrayExpression withObjExpression(Expression objExpression) {
        this.setObjExpression(objExpression);
        return this;
    }

    public ArrayExpression withIndexExpression(Expression indexExpression) {
        this.setIndexExpression(indexExpression);
        return this;
    }

    public ArrayExpression withRangeExpression(Expression startIndexExpression, Expression stopIndexExpression) {
        this.setStartIndexExpression(startIndexExpression);
        this.setStopIndexExpression(stopIndexExpression);
        return this;
    }

    public <E extends Expression> E getObjExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getObjExpression()));
    }

    public <E extends Expression> E getIndexExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getIndexExpression()));
    }
}

