/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public abstract class AbstractObjectReference<CONTAINER extends DBSObject>
implements DBSObjectReference {
    private final String name;
    private final CONTAINER container;
    private final String description;
    private final Class<?> objectClass;
    private final DBSObjectType type;
    private final String extraInfo;

    protected AbstractObjectReference(String name, CONTAINER container, String description, Class<?> objectClass, DBSObjectType type) {
        this(name, container, description, objectClass, type, null);
    }

    protected AbstractObjectReference(String name, CONTAINER container, String description, Class<?> objectClass, DBSObjectType type, String extraInfo) {
        this.name = name;
        this.container = container;
        this.description = description;
        this.objectClass = objectClass;
        this.type = type;
        this.extraInfo = extraInfo;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public CONTAINER getContainer() {
        return this.container;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    @Override
    public String getObjectDescription() {
        return this.description;
    }

    @Override
    public DBSObjectType getObjectType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        if (this.extraInfo != null) {
            return this.extraInfo;
        }
        if (this.container == null) {
            return this.name;
        }
        DBPDataSource dataSource = this.container.getDataSource();
        if (dataSource == null) {
            return this.name;
        }
        String fqName = this.container == dataSource ? DBUtils.getQuotedIdentifier(dataSource, this.name) : DBUtils.getFullQualifiedName(dataSource, new DBPNamedObject[]{this.container, this});
        return fqName;
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.UI);
    }
}

