/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public final class JSONBestNumberSerializer
implements JsonSerializer<Number>,
JsonDeserializer<Number> {
    public JsonElement serialize(Number src, Type srcType, JsonSerializationContext context) {
        return new JsonPrimitive(src.toString());
    }

    public Number deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        String s = json.getAsString();
        if (s.contains(".") || s.contains("E")) {
            return Double.parseDouble(s);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException2) {
                return Double.parseDouble(s);
            }
        }
    }
}

