/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingContainer;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingType;
import org.jkiss.utils.CommonUtils;

public class StreamMappingAttribute
implements DBPNamedObject,
DBPImageProvider {
    private final StreamMappingContainer container;
    private final DBSAttributeBase attribute;
    private StreamMappingType mappingType;

    public StreamMappingAttribute(@NotNull StreamMappingContainer container, @NotNull DBSAttributeBase attribute, @NotNull StreamMappingType mappingType) {
        this.container = container;
        this.attribute = attribute;
        this.mappingType = mappingType;
    }

    public StreamMappingAttribute(@NotNull StreamMappingContainer container, @NotNull StreamMappingAttribute other) {
        this.container = container;
        this.attribute = other.attribute;
        this.mappingType = other.mappingType;
    }

    @NotNull
    public String getName() {
        return DBUtils.getObjectFullName((DBPNamedObject)this.attribute, (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    @NotNull
    public DBPImage getObjectImage() {
        return DBValueFormatting.getObjectImage((DBPObject)this.attribute);
    }

    @NotNull
    public StreamMappingContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBSAttributeBase getAttribute() {
        return this.attribute;
    }

    @NotNull
    public StreamMappingType getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(@NotNull StreamMappingType mappingType) {
        this.mappingType = mappingType;
    }

    public void loadSettings(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> attributeSettings) {
        String type = JSONUtils.getString(attributeSettings, (String)"mappingType");
        if (CommonUtils.isNotEmpty((String)type)) {
            this.mappingType = (StreamMappingType)CommonUtils.valueOf(StreamMappingType.class, (String)type, (Enum)StreamMappingType.unspecified);
        }
    }

    public void saveSettings(@NotNull Map<String, Object> attributeSettings) {
        attributeSettings.put("mappingType", this.mappingType.name());
    }
}

