/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jface.widgets.AbstractCompositeFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public final class SectionFactory
extends AbstractCompositeFactory<SectionFactory, Section> {
    private SectionFactory(int style) {
        super(SectionFactory.class, parent -> new Section((Composite)parent, style));
    }

    public static SectionFactory newSection(int style) {
        return new SectionFactory(style);
    }

    public SectionFactory title(String title) {
        this.addProperty(section -> section.setText(title));
        return this;
    }

    public SectionFactory description(String description) {
        this.addProperty(section -> section.setDescription(description));
        return this;
    }

    public SectionFactory description(Function<Section, Control> controlFunction) {
        this.addProperty(section -> section.setDescriptionControl((Control)controlFunction.apply((Section)section)));
        return this;
    }

    public SectionFactory onExpanded(Consumer<ExpansionEvent> consumer) {
        this.addProperty(section -> section.addExpansionListener(IExpansionListener.expansionStateChangingAdapter(consumer)));
        return this;
    }

    public SectionFactory onExpanding(Consumer<ExpansionEvent> consumer) {
        this.addProperty(section -> section.addExpansionListener(IExpansionListener.expansionStateChangingAdapter(consumer)));
        return this;
    }
}

