/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.data;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MySQLGeometryValueHandler
extends GISGeometryValueHandler {
    static final MySQLGeometryValueHandler INSTANCE = new MySQLGeometryValueHandler();

    public MySQLGeometryValueHandler() {
        this.setInvertCoordinates(true);
        this.setLeadingSRID(true);
    }

    @NotNull
    public DBGeometry getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        DBGeometry geometry = super.getValueFromObject(session, type, object, copy, validateValue);
        if (geometry.getSRID() == 0) {
            MySQLTableColumn c;
            if (type instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)type;
                type = binding.getEntityAttribute();
            }
            if (type instanceof MySQLTableColumn && (c = (MySQLTableColumn)type).getSrid() != null) {
                geometry.setSRID(c.getSrid().intValue());
            }
        }
        return geometry;
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (format == DBDDisplayFormat.NATIVE) {
            int srid = 0;
            if (value instanceof DBGeometry) {
                DBGeometry geometry = (DBGeometry)value;
                srid = geometry.getSRID();
            }
            if (srid == 0) {
                MySQLTableColumn c;
                if (column instanceof DBDAttributeBinding) {
                    DBDAttributeBinding binding = (DBDAttributeBinding)column;
                    column = binding.getEntityAttribute();
                }
                if (column instanceof MySQLTableColumn && (c = (MySQLTableColumn)column).getSrid() != null) {
                    srid = c.getSrid();
                }
            }
            if (srid != 0) {
                return "ST_GeomFromText('" + value.toString() + "', " + srid + ")";
            }
            return "ST_GeomFromText('" + value.toString() + "')";
        }
        return super.getValueDisplayString(column, value, format);
    }
}

