/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericDataType;
import org.jkiss.dbeaver.ext.generic.model.GenericDataTypeArray;
import org.jkiss.dbeaver.ext.generic.model.GenericDataTypeCache;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;

class ClickhouseDataTypeCache
extends GenericDataTypeCache {
    public ClickhouseDataTypeCache(GenericStructContainer container) {
        super(container);
    }

    protected void addCustomObjects(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer owner, @NotNull List<GenericDataType> genericDataTypes) {
        if (DBUtils.findObject(genericDataTypes, (String)"Int128") == null) {
            genericDataTypes.add(new GenericDataType((GenericStructContainer)this.owner, 2, "Int128", "Int128", false, false, 0, 0, 0));
        }
        if (DBUtils.findObject(genericDataTypes, (String)"Int256") == null) {
            genericDataTypes.add(new GenericDataType((GenericStructContainer)this.owner, 2, "Int256", "Int256", false, false, 0, 0, 0));
        }
        if (DBUtils.findObject(genericDataTypes, (String)"UInt128") == null) {
            genericDataTypes.add(new GenericDataType((GenericStructContainer)this.owner, 2, "UInt128", "UInt128", false, false, 0, 0, 0));
        }
        if (DBUtils.findObject(genericDataTypes, (String)"UInt256") == null) {
            genericDataTypes.add(new GenericDataType((GenericStructContainer)this.owner, 2, "UInt256", "UInt256", false, false, 0, 0, 0));
        }
        if (DBUtils.findObject(genericDataTypes, (String)"Decimal") == null) {
            genericDataTypes.add(new GenericDataType((GenericStructContainer)this.owner, 3, "Decimal", "Decimal", false, false, 0, 0, 0));
        }
        if (DBUtils.findObject(genericDataTypes, (String)"Bool") == null) {
            genericDataTypes.add(new GenericDataType((GenericStructContainer)this.owner, 16, "Bool", "Bool", false, false, 0, 0, 0));
        }
        for (GenericDataType dt : new ArrayList<GenericDataType>(genericDataTypes)) {
            genericDataTypes.add((GenericDataType)new GenericDataTypeArray((GenericStructContainer)dt.getParentObject(), 2003, "Array(" + dt.getName() + ")", "Array of " + dt.getName(), (DBSDataType)dt));
        }
        if (DBUtils.findObject(genericDataTypes, (String)"DateTime64") == null) {
            genericDataTypes.add(new GenericDataType((GenericStructContainer)this.owner, 93, "DateTime64", "DateTime64", false, false, 0, 0, 0));
        }
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer genericStructContainer) throws SQLException {
        record Entry(String name, int precision, boolean isUnsigned, int minimumScale, int maximumScale, int sqlDataType) {
            public String toSelectStatement(boolean withColumnNames) {
                List<Integer> values = List.of("'" + this.name + "'", Integer.valueOf(this.precision), Boolean.valueOf(this.isUnsigned), Integer.valueOf(this.minimumScale), Integer.valueOf(this.maximumScale), Integer.valueOf(this.sqlDataType));
                return "select " + (withColumnNames ? IntStream.range(0, values.size()).mapToObj(i -> values.get(i).toString() + " as c" + (i + 1)).collect(Collectors.joining(",")) : values.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
        }
        List<Entry> knownTypeEntries = List.of(new Entry("Bool", 1, true, 0, 0, 16), new Entry("Date", 10, false, 0, 0, 91), new Entry("Date32", 10, false, 0, 0, 91), new Entry("DateTime", 29, false, 0, 9, 93), new Entry("DateTime32", 19, false, 0, 0, 93), new Entry("DateTime64", 29, false, 0, 9, 93), new Entry("Enum", 0, false, 0, 0, 0), new Entry("Enum8", 0, false, 0, 0, 0), new Entry("Enum16", 0, false, 0, 0, 0), new Entry("FixedString", 0, false, 0, 0, 12), new Entry("Int8", 3, true, 0, 0, 2), new Entry("UInt8", 3, false, 0, 0, 2), new Entry("Int16", 5, true, 0, 0, 2), new Entry("UInt16", 5, false, 0, 0, 2), new Entry("Int32", 10, true, 0, 0, 2), new Entry("UInt32", 10, false, 0, 0, 2), new Entry("Int64", 19, true, 0, 0, 2), new Entry("IntervalYear", 19, true, 0, 0, 0), new Entry("IntervalQuarter", 19, true, 0, 0, 0), new Entry("IntervalMonth", 19, true, 0, 0, 0), new Entry("IntervalWeek", 19, true, 0, 0, 0), new Entry("IntervalDay", 19, true, 0, 0, 0), new Entry("IntervalHour", 19, true, 0, 0, 0), new Entry("IntervalMinute", 19, true, 0, 0, 0), new Entry("IntervalSecond", 19, true, 0, 0, 0), new Entry("IntervalMicrosecond", 19, true, 0, 0, 0), new Entry("IntervalMillisecond", 19, true, 0, 0, 0), new Entry("IntervalNanosecond", 19, true, 0, 0, 0), new Entry("UInt64", 20, false, 0, 0, 2), new Entry("Int128", 39, true, 0, 0, 2), new Entry("UInt128", 39, false, 0, 0, 2), new Entry("Int256", 77, true, 0, 0, 2), new Entry("UInt256", 78, false, 0, 0, 2), new Entry("Decimal", 76, true, 0, 76, 2), new Entry("Decimal32", 9, true, 0, 9, 2), new Entry("Decimal64", 18, true, 0, 18, 2), new Entry("Decimal128", 38, true, 0, 38, 2), new Entry("Decimal256", 76, true, 0, 76, 2), new Entry("BFloat16", 3, true, 0, 16, 2), new Entry("Float32", 12, true, 0, 38, 2), new Entry("Float64", 22, true, 0, 308, 2), new Entry("IPv4", 10, false, 0, 0, 0), new Entry("IPv6", 39, false, 0, 0, 0), new Entry("UUID", 69, false, 0, 0, 0), new Entry("Point", 0, true, 0, 0, 0), new Entry("Polygon", 0, true, 0, 0, 0), new Entry("MultiPolygon", 0, true, 0, 0, 0), new Entry("Ring", 0, true, 0, 0, 0), new Entry("LineString", 0, true, 0, 0, 0), new Entry("MultiLineString", 0, true, 0, 0, 0), new Entry("JSON", 0, false, 0, 0, 0), new Entry("Object", 0, false, 0, 0, 0), new Entry("String", 0, false, 0, 0, 12), new Entry("Array", 0, false, 0, 0, 2003), new Entry("Map", 0, false, 0, 0, 0), new Entry("Nested", 0, false, 0, 0, 0), new Entry("Tuple", 0, false, 0, 0, 0), new Entry("Nothing", 0, false, 0, 0, 0), new Entry("LowCardinality", 0, false, 0, 0, 0), new Entry("Nullable", 0, false, 0, 0, 0), new Entry("SimpleAggregateFunction", 0, false, 0, 0, 0), new Entry("AggregateFunction", 0, false, 0, 0, 0), new Entry("Variant", 0, false, 0, 0, 0), new Entry("Dynamic", 0, false, 0, 0, 0));
        String sql = "SELECT\n    dt.name AS TYPE_NAME,\n    dt.alias_to AS TYPE_ALIAS, -- in driver, it was if(empty(alias_to), name, alias_to) AS DATA_TYPE\n    attrs.c2 AS PRECISION,\n    NULL AS LITERAL_PREFIX,\n    NULL AS LITERAL_SUFFIX,\n    NULL AS CREATE_PARAMS,\n    dt.name AS NULLABLE,\n    not(dt.case_insensitive)::Boolean AS CASE_SENSITIVE,\n    3 AS SEARCHABLE,\n    not(attrs.c3)::Boolean AS UNSIGNED_ATTRIBUTE,\n    false AS FIXED_PREC_SCALE,\n    false AS AUTO_INCREMENT,\n    dt.name AS LOCAL_TYPE_NAME,\n    attrs.c4 AS MINIMUM_SCALE,\n    attrs.c5 AS MAXIMUM_SCALE,\n    attrs.c6 AS DATA_TYPE, -- it's our attribute with data kind information\n    0 AS SQL_DATETIME_SUB,\n    0 AS NUM_PREC_RADIX\nFROM system.data_type_families dt\nLEFT JOIN (" + knownTypeEntries.get(0).toSelectStatement(true) + " UNION ALL " + knownTypeEntries.stream().skip(1L).map(e -> e.toSelectStatement(false)).collect(Collectors.joining(" UNION ALL ")) + ") as attrs ON (dt.name = attrs.c1 or dt.alias_to = attrs.c1)\n";
        return session.prepareStatement(sql);
    }
}

