/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructImpl;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeDynamic;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeMap;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeStatic;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeUnknown;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCComplexValueHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCStructValueHandler
extends JDBCComplexValueHandler
implements DBDValueHandlerComposite {
    private static final Log log = Log.getLog(JDBCStructValueHandler.class);
    public static final JDBCStructValueHandler INSTANCE = new JDBCStructValueHandler();

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof JDBCComposite) {
            if (DBUtils.isNullValue((Object)value)) {
                return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
            }
            return ((JDBCComposite)value).getStringRepresentation();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return JDBCComposite.class;
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, 2002);
        } else if (value instanceof DBDComposite) {
            DBDComposite struct = (DBDComposite)value;
            if (struct.isNull()) {
                statement.setNull(paramIndex, 2002);
            } else if (struct instanceof JDBCComposite) {
                statement.setObject(paramIndex, (Object)((JDBCComposite)struct).getStructValue(), 2002);
            } else {
                statement.setObject(paramIndex, struct.getRawValue());
            }
        } else {
            throw new DBCException("Struct parameter type '" + value.getClass().getName() + "' not supported");
        }
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        String typeName;
        if (object instanceof JDBCComposite) {
            return copy ? ((JDBCComposite)object).cloneValue(session.getProgressMonitor()) : object;
        }
        try {
            typeName = object instanceof Struct ? ((Struct)object).getSQLTypeName() : type.getTypeName();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
        DBSDataType dataType = null;
        try {
            dataType = DBUtils.resolveDataType((DBRProgressMonitor)session.getProgressMonitor(), (DBPDataSource)session.getDataSource(), (String)typeName);
        }
        catch (DBException e) {
            log.debug((Object)("Error resolving data type '" + typeName + "'"), (Throwable)e);
        }
        if (dataType == null) {
            if (object instanceof Struct) {
                return new JDBCCompositeDynamic(session, (Struct)object, null);
            }
            return new JDBCCompositeUnknown(session, object);
        }
        if (object == null) {
            return new JDBCCompositeStatic(session, dataType, new JDBCStructImpl(dataType.getTypeName(), null, ""));
        }
        if (object instanceof Struct) {
            return new JDBCCompositeStatic(session, dataType, (Struct)object);
        }
        if (object instanceof Map) {
            return new JDBCCompositeMap(session, dataType, (Map)object);
        }
        return new JDBCCompositeUnknown(session, object);
    }
}

