/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQQueryException;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQStackTraceElement;
import net.xqj.core.exception.XQExceptionImpl;

public class XQQueryExceptionImpl
extends XQQueryException {
    private String detailedMessage = null;

    public XQQueryExceptionImpl(String message, String vendorCode, QName errorCode, int line, int column, int position, String moduleURI, XQSequence errorObject, XQStackTraceElement[] stackTrace) {
        super(message, vendorCode, errorCode, line, column, position, moduleURI, errorObject, stackTrace);
    }

    public void setDetailedMessage(String detailedMessage) {
        this.detailedMessage = detailedMessage;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public Throwable getCause() {
        return super.getCause();
    }

    public String getLocalizedMessage() {
        if (this.getDetailedMessage() != null) {
            return this.getDetailedMessage();
        }
        return this.getMessage();
    }

    private synchronized void printXQueryStackTrace(PrintWriter out, XQStackTraceElement[] trace) {
        for (int i = 0; i < trace.length; ++i) {
            if (trace[i].getFunctionQName() != null) {
                out.print("\tat " + trace[i].getFunctionQName());
            } else if (trace[i].getFunctionQName() == null || String.valueOf(trace[i].getFunctionQName()).equals("/eval")) {
                out.print("\tat ");
            }
            out.print('(');
            if (trace[i].getModuleURI() == null || trace[i].getModuleURI().equals("/eval")) {
                out.print("Ad-Hoc Query Evaluation");
            } else {
                out.print(trace[i].getModuleURI());
            }
            if (trace[i].getLineNumber() != -1) {
                out.print(':');
                out.print(trace[i].getLineNumber());
                if (trace[i].getColumnNumber() != -1) {
                    out.print('/');
                    out.print(trace[i].getColumnNumber());
                }
            }
            out.println(')');
        }
    }

    public synchronized void printJavaStackTrace(PrintWriter out) {
        StackTraceElement[] stackTrace = this.getStackTrace();
        if (stackTrace == null) {
            return;
        }
        for (int i = 0; i < stackTrace.length; ++i) {
            String className;
            if (stackTrace[i].getMethodName().length() <= 2 || XQExceptionImpl.containsObfuscatedClass(className = stackTrace[i].getClassName())) continue;
            out.print("\tat ");
            out.print(className);
            out.print('.');
            out.print(stackTrace[i].getMethodName());
            if (stackTrace[i].getFileName() != null) {
                out.print('(');
                out.print(stackTrace[i].getFileName());
                if (stackTrace[i].getLineNumber() > 0) {
                    out.print(':');
                    out.print(stackTrace[i].getLineNumber());
                }
                out.print(")");
            } else {
                out.print("(Unknown Source)");
            }
            out.println();
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        PrintWriter writer = new PrintWriter(out);
        this.printStackTrace(writer);
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        buffer.append(this.getErrorCode().getLocalPart());
        buffer.append("]: ");
        buffer.append(super.getMessage());
        return buffer.toString();
    }

    public synchronized void printStackTrace(PrintWriter out) {
        XQStackTraceElement[] xqStackTrace;
        out.print("javax.xml.xquery.XQQueryException: ");
        out.println(this.getMessage());
        if (this.getDetailedMessage() != null) {
            out.println(this.getDetailedMessage());
        }
        if ((xqStackTrace = this.getQueryStackTrace()) != null) {
            out.println();
            out.println("XQuery Stack Trace");
            out.println();
            this.printXQueryStackTrace(out, xqStackTrace);
        }
        out.println();
        out.println("Java Stack Trace");
        out.println();
        this.printJavaStackTrace(out);
        out.flush();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        buffer.append(this.getErrorCode().getLocalPart());
        buffer.append("]: ");
        if (this.getDetailedMessage() != null) {
            buffer.append(this.getDetailedMessage());
        } else {
            buffer.append(super.getMessage());
        }
        buffer.append('\n');
        return buffer.toString();
    }
}

