/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQStaticContext;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.XQExpression3;
import net.xqj.core.XQPreparedExpression3;
import net.xqj.core.XQToolkit;
import net.xqj.core.XQueryCorrectorOutputStream;
import net.xqj.core.XQueryCorrectorWriter;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.io.UTF8Reader;
import net.xqj.core.io.UTF8Writer;
import net.xqj.core.util.xmlcalendar.DurationImpl;
import net.xqj.core.util.xmlcalendar.XMLGregorianCalendarImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class Factory {
    private static SAXParserFactory defaultSAXParserFactory = null;
    private static XMLInputFactory defaultXMLInputFactory = null;
    private static XMLOutputFactory defaultXMLOutputFactory = null;
    private static Document nodeFactory = null;

    private Factory() {
    }

    public static final XQueryCorrectorOutputStream newXQueryCorrector(OutputStream out) {
        return new XQueryCorrectorOutputStream(out);
    }

    public static final XQueryCorrectorWriter newXQueryCorrector(Writer out) {
        return new XQueryCorrectorWriter(out);
    }

    public static final SAXParser newSAXParser() throws XQException {
        try {
            SAXParser parser = defaultSAXParserFactory.newSAXParser();
            return parser;
        }
        catch (Exception e) {
            throw new XQExceptionImpl("Unable to create new SAXParser object.", "XQJFA001", e);
        }
    }

    public static final void setSAXParserFactory() throws XQException {
        defaultSAXParserFactory = SAXParserFactory.newInstance();
    }

    public static final XMLStreamReader newXMLStreamReader(InputStream in) throws XMLStreamException {
        return defaultXMLInputFactory.createXMLStreamReader(in);
    }

    public static final XMLStreamReader newXMLStreamReader(InputStream stream, String encoding) throws XQException {
        try {
            return defaultXMLInputFactory.createXMLStreamReader(stream, encoding);
        }
        catch (XMLStreamException e) {
            throw new XQExceptionImpl("Unable to load default XMLInputFactory.", "XQJFA004", e);
        }
    }

    public static final XMLStreamReader newXMLStreamReader(Reader reader) throws XQException {
        try {
            return defaultXMLInputFactory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new XQExceptionImpl("Unable to load default XMLInputFactory.", "XQJFA005", e);
        }
    }

    public static final XMLStreamReader newXMLStreamReader(Source source) throws XQException {
        try {
            return defaultXMLInputFactory.createXMLStreamReader(source);
        }
        catch (XMLStreamException e) {
            throw new XQExceptionImpl("Unable to load default XMLInputFactory.", "XQJFA006", e);
        }
    }

    public static final XMLInputFactory setXMLInputFactory() throws XQException {
        String factoryClassName = Factory.getXMLInputFactoryClassName();
        try {
            XMLInputFactory factory = factoryClassName != null ? (XMLInputFactory)Class.forName(factoryClassName).newInstance() : XMLInputFactory.newInstance();
            return factory;
        }
        catch (Exception e) {
            throw new XQExceptionImpl("Unable to load default XMLInputFactory. (" + factoryClassName + ")", "XQJFA002", e);
        }
    }

    public static final String getXMLInputFactoryClassName() {
        String userPreferred = System.getProperty("javax.xml.stream.XMLInputFactory");
        if (userPreferred != null) {
            return userPreferred;
        }
        return Factory.getFirstClassThatExists(new String[]{"com.fasterxml.aalto.stax.InputFactoryImpl", "com.ctc.wstx.stax.WstxInputFactory"});
    }

    private static final String getFirstClassThatExists(String[] classNameArray) {
        for (int i = 0; i < classNameArray.length; ++i) {
            try {
                Class<?> clazz = Class.forName(classNameArray[i]);
                return classNameArray[i];
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }

    public static final String getXMLOutputFactoryClassName() {
        String userPreferred = System.getProperty("javax.xml.stream.XMLOutputFactory");
        if (userPreferred != null) {
            return userPreferred;
        }
        return Factory.getFirstClassThatExists(new String[]{"com.fasterxml.aalto.stax.OutputFactoryImpl"});
    }

    public static final XMLOutputFactory newXMLOutputFactory() throws XQException {
        String xmlOutputFactoryClassName = Factory.getXMLOutputFactoryClassName();
        try {
            XMLOutputFactory factory = xmlOutputFactoryClassName != null ? (XMLOutputFactory)Class.forName(xmlOutputFactoryClassName).newInstance() : XMLOutputFactory.newInstance();
            return factory;
        }
        catch (Exception e) {
            throw new XQExceptionImpl("Unable to load default XMLOutputFactory (" + xmlOutputFactoryClassName + ").", "XQJFA014", e);
        }
    }

    public static final XMLStreamWriter newXMLStreamWriter(OutputStream stream, String encoding) throws XQException {
        try {
            return defaultXMLOutputFactory.createXMLStreamWriter(stream, encoding);
        }
        catch (XMLStreamException e) {
            throw new XQExceptionImpl("Unable to load default XMLInputFactory.", "XQJFA004", e);
        }
    }

    public static final Source newSource(InputStream inputStream) throws XQException {
        try {
            return new SAXSource(Factory.newSAXParser().getXMLReader(), Factory.newInputSource(inputStream));
        }
        catch (SAXException e) {
            throw new XQExceptionImpl("SAXException while creating SAX Parser.", "XQJFA015", e);
        }
    }

    public static final Source newSource(InputStream inputStream, String baseURI) throws XQException {
        try {
            return new SAXSource(Factory.newSAXParser().getXMLReader(), Factory.newInputSource(inputStream, baseURI));
        }
        catch (SAXException e) {
            throw new XQExceptionImpl("SAXException while creating SAX Parser.", "XQJFA016", e);
        }
    }

    public static final Source newSource(Reader reader, String baseURI) throws XQException {
        try {
            return new SAXSource(Factory.newSAXParser().getXMLReader(), Factory.newInputSource(reader, baseURI));
        }
        catch (SAXException e) {
            throw new XQExceptionImpl("SAXException while creating SAX Parser.", "XQJFA017", e);
        }
    }

    public static final Source newSource(Reader reader) throws XQException {
        try {
            XMLReader xmlReader = Factory.newSAXParser().getXMLReader();
            return new SAXSource(xmlReader, Factory.newInputSource(reader));
        }
        catch (SAXException e) {
            throw new XQExceptionImpl("SAXException while creating SAX Parser.", "XQJFA018", e);
        }
    }

    public static final Source newSource(Node node) {
        return new DOMSource(node);
    }

    public static final Source newSource(String xmlDocument) throws XQException {
        SAXSource source = (SAXSource)Factory.newSource(new StringReader(xmlDocument));
        return source;
    }

    public static final Source newSource(String xmlDocument, String baseURI) throws XQException {
        return Factory.newSource(new StringReader(xmlDocument), baseURI);
    }

    public static final Source newSource(XMLStreamReader reader) {
        return new StAXSource(reader);
    }

    public static final Result newResult(Writer writer) {
        return new StreamResult(writer);
    }

    public static final Result newResult(OutputStream out) {
        return new StreamResult(out);
    }

    public static final Result newResult(ContentHandler handler) {
        return new SAXResult(handler);
    }

    private static final Document newNodeFactory() throws XQException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XQExceptionImpl("Failed to create a DocumentBuilderFactory instance.", "XQJFA011", e);
        }
    }

    public static final Text newTextNode(String lexicalString) {
        return nodeFactory.createTextNode(lexicalString);
    }

    public static final Comment newCommentNode(String lexicalString) throws XQException {
        if (lexicalString == null) {
            throw new XQExceptionImpl("lexical value of a comment can not be null.", "XQJFA008");
        }
        int ltIndex = lexicalString.indexOf("<!--");
        int gtIndex = lexicalString.lastIndexOf("-->");
        if (ltIndex == -1 || gtIndex == -1 || gtIndex <= ltIndex) {
            return nodeFactory.createComment(lexicalString);
        }
        String stringData = lexicalString.substring(ltIndex + 4, gtIndex);
        return nodeFactory.createComment(stringData);
    }

    public static final ProcessingInstruction newProcessingInstructionNode(String lexicalString) throws XQException {
        int start = lexicalString.indexOf("<?");
        int end = lexicalString.indexOf("?>");
        int startData = lexicalString.indexOf(32, start) + 1;
        if (start == -1 || end == -1 || end < start) {
            throw new XQExceptionImpl("Invalid Processing Instruction \"" + lexicalString + "\".", "XQJFA010");
        }
        String target = lexicalString.substring(start + 2, startData - 1);
        String data = lexicalString.substring(startData, end);
        return nodeFactory.createProcessingInstruction(target, data);
    }

    public static final ProcessingInstruction newProcessingInstructionNode(String target, String data) throws XQException {
        return nodeFactory.createProcessingInstruction(target, data);
    }

    public static final Element newElementNode(String tagName) {
        return Factory.newElementNode("", tagName);
    }

    public static final Element newElementNode(String namespaceUri, String qualifiedName) {
        return nodeFactory.createElementNS(namespaceUri, qualifiedName);
    }

    public static final Attr newAttrNode(QName qname, String value) {
        return Factory.newAttrNode(qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI(), value);
    }

    public static final Attr newAttrNode(String prefix, String localPart, String namespaceURI, String value) {
        Attr attr = nodeFactory.createAttributeNS(namespaceURI, localPart);
        attr.setPrefix(prefix);
        attr.setValue(value);
        return attr;
    }

    public static final DocumentFragment newDocumentFragment() {
        return nodeFactory.createDocumentFragment();
    }

    public static final InputSource newInputSource(InputStream in) {
        return new InputSource(in);
    }

    public static final InputSource newInputSource(InputStream in, String baseURI) {
        InputSource source = Factory.newInputSource(in);
        source.setSystemId(baseURI);
        return source;
    }

    public static final InputSource newInputSource(Reader reader) {
        return new InputSource(reader);
    }

    public static final InputSource newInputSource(Reader reader, String baseURI) {
        InputSource source = Factory.newInputSource(reader);
        source.setSystemId(baseURI);
        return source;
    }

    public static XQPreparedExpression newXQPreparedExpression(GenericXQConnection connection, InputStream xquery) throws XQException {
        return Factory.newXQPreparedExpression(connection, xquery, connection.getStaticContext());
    }

    public static XQPreparedExpression newXQPreparedExpression(GenericXQConnection connection, InputStream xquery, XQStaticContext properties) throws XQException {
        return Factory.newXQPreparedExpression(connection, Factory.newUTF8Reader(xquery), properties);
    }

    public static XQPreparedExpression newXQPreparedExpression(GenericXQConnection connection, Reader xquery) throws XQException {
        return Factory.newXQPreparedExpression(connection, xquery, connection.getStaticContext());
    }

    public static XQPreparedExpression newXQPreparedExpression(GenericXQConnection connection, Reader xquery, XQStaticContext properties) throws XQException {
        return XQPreparedExpression3.newInstance(connection, xquery, properties);
    }

    public static XQPreparedExpression newXQPreparedExpression(GenericXQConnection connection, String xquery) throws XQException {
        return Factory.newXQPreparedExpression(connection, new StringReader(xquery));
    }

    public static XQPreparedExpression newXQPreparedExpression(GenericXQConnection connection, String xquery, XQStaticContext properties) throws XQException {
        return Factory.newXQPreparedExpression(connection, new StringReader(xquery), properties);
    }

    public static XQExpression newXQExpression(GenericXQConnection connection, XQStaticContext properties) throws XQException {
        return XQExpression3.newInstance(connection, properties);
    }

    public static XQExpression newXQExpression(GenericXQConnection connection) throws XQException {
        return Factory.newXQExpression(connection, connection.getStaticContext());
    }

    public static Reader newUTF8Reader(InputStream in) throws XQException {
        UTF8Reader reader = new UTF8Reader();
        reader.setInput(in);
        return reader;
    }

    public static Writer newUTF8Writer(OutputStream out) throws XQException {
        return new UTF8Writer(out);
    }

    public static Reader newReader(InputStream in) throws XQException {
        PushbackInputStream pin = new PushbackInputStream(in, 4);
        byte[] byteOrderMark = new byte[4];
        try {
            int read = pin.read(byteOrderMark);
            if (read >= 3 && byteOrderMark[0] == -17 && byteOrderMark[1] == -69 && byteOrderMark[2] == -65) {
                pin.unread(byteOrderMark, 3, 1);
                return Factory.newUTF8Reader(pin);
            }
            if (read >= 2 && byteOrderMark[0] == -2 && byteOrderMark[1] == -1) {
                pin.unread(byteOrderMark, 2, 2);
                return new InputStreamReader((InputStream)pin, "UTF-16BE");
            }
            if (read >= 2 && byteOrderMark[0] == -1 && byteOrderMark[1] == -2) {
                pin.unread(byteOrderMark, 2, 2);
                return new InputStreamReader((InputStream)pin, "UTF-16LE");
            }
            if (read >= 4 && byteOrderMark[0] == 0 && byteOrderMark[1] == 0 && byteOrderMark[2] == -2 && byteOrderMark[3] == -1) {
                return new InputStreamReader((InputStream)pin, "UTF-32BE");
            }
            if (read >= 4 && byteOrderMark[0] == -1 && byteOrderMark[1] == -2 && byteOrderMark[2] == 0 && byteOrderMark[3] == 0) {
                return new InputStreamReader((InputStream)pin, "UTF-32LE");
            }
            pin.unread(byteOrderMark, 0, read);
            return Factory.newUTF8Reader(pin);
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJFA012", e);
        }
    }

    public static final Writer newWriter(OutputStream out, String encoding, boolean writeByteOrderMark) throws XQException {
        if (writeByteOrderMark) {
            XQToolkit.writeByteOrderMark(out, encoding);
        }
        if (encoding == null || encoding.equalsIgnoreCase("UTF-8") || encoding.equals("UTF8")) {
            return Factory.newUTF8Writer(out);
        }
        try {
            if (encoding.equalsIgnoreCase("UTF-16") || encoding.equalsIgnoreCase("UTF16")) {
                encoding = "UTF-16BE";
            }
            return new OutputStreamWriter(out, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJFA013", e);
        }
    }

    public static final XMLGregorianCalendar newXMLGregorianCalendar(String lexicalRepresentation) {
        return XMLGregorianCalendarImpl.parse(lexicalRepresentation);
    }

    public static final XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar calendar) {
        return new XMLGregorianCalendarImpl(calendar);
    }

    public static final XMLGregorianCalendar newXMLGregorianCalendar(Calendar calendar) {
        return Factory.newXMLGregorianCalendar(calendar.getTime());
    }

    public static final XMLGregorianCalendar newXMLGregorianCalendar(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return Factory.newXMLGregorianCalendar(gc);
    }

    public static final GregorianCalendar newGregorianCalendar(String lexicalDateTime) {
        XMLGregorianCalendar xgc = Factory.newXMLGregorianCalendar(lexicalDateTime);
        TimeZone tz = TimeZone.getDefault();
        tz.setRawOffset(xgc.getTimezone() * 60 * 1000);
        GregorianCalendar gc = xgc.toGregorianCalendar(tz, Locale.getDefault(), xgc);
        return gc;
    }

    public static final Calendar newCalendar(String lexicalDateTime) {
        return Factory.newGregorianCalendar(lexicalDateTime);
    }

    public static final Date newDate(String lexicalDateTime) {
        return Factory.newGregorianCalendar(lexicalDateTime).getTime();
    }

    public static final Duration newDuration(String lexicalDuration) {
        return DurationImpl.parse(lexicalDuration);
    }

    private static final boolean classExists(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        try {
            Factory.setSAXParserFactory();
            defaultSAXParserFactory.setNamespaceAware(true);
            defaultXMLInputFactory = Factory.setXMLInputFactory();
            defaultXMLOutputFactory = Factory.newXMLOutputFactory();
            nodeFactory = Factory.newNodeFactory();
        }
        catch (XQException e) {
            e.printStackTrace();
            throw new RuntimeException("XQJ implementation cannot load vital XML factories: " + e.getMessage(), e);
        }
    }
}

