/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpOp;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Concat;
import org.basex.query.expr.Except;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.List;
import org.basex.query.expr.Or;
import org.basex.query.expr.Otherwise;
import org.basex.query.expr.Range;
import org.basex.query.expr.Union;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;

public final class FnOp
extends StandardFunc {
    private static final QNm Q_X = new QNm("x");
    private static final QNm Q_Y = new QNm("y");

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String operator = this.toString(this.arg(0), qc);
        int pl = 2;
        VarScope vs = new VarScope();
        Var[] params = new Var[2];
        Expr[] args = new Expr[2];
        for (int p = 0; p < 2; ++p) {
            params[p] = vs.addNew(p == 0 ? Q_X : Q_Y, null, qc, this.info);
            args[p] = new VarRef(this.info, params[p]);
        }
        Expr arg1 = args[0];
        Expr arg2 = args[1];
        Arr body = switch (operator) {
            case "," -> new List(this.info, arg1, arg2);
            case "and" -> new And(this.info, arg1, arg2);
            case "or" -> new Or(this.info, arg1, arg2);
            case "+" -> new Arith(this.info, arg1, arg2, Calc.ADD);
            case "-" -> new Arith(this.info, arg1, arg2, Calc.SUBTRACT);
            case "*" -> new Arith(this.info, arg1, arg2, Calc.MULTIPLY);
            case "div" -> new Arith(this.info, arg1, arg2, Calc.DIVIDE);
            case "idiv" -> new Arith(this.info, arg1, arg2, Calc.DIVIDEINT);
            case "mod" -> new Arith(this.info, arg1, arg2, Calc.MODULO);
            case "=" -> new CmpG(this.info, arg1, arg2, CmpOp.EQ);
            case "<" -> new CmpG(this.info, arg1, arg2, CmpOp.LT);
            case "<=" -> new CmpG(this.info, arg1, arg2, CmpOp.LE);
            case ">" -> new CmpG(this.info, arg1, arg2, CmpOp.GT);
            case ">=" -> new CmpG(this.info, arg1, arg2, CmpOp.GE);
            case "!=" -> new CmpG(this.info, arg1, arg2, CmpOp.NE);
            case "eq" -> new CmpV(this.info, arg1, arg2, CmpOp.EQ);
            case "lt" -> new CmpV(this.info, arg1, arg2, CmpOp.LT);
            case "le" -> new CmpV(this.info, arg1, arg2, CmpOp.LE);
            case "gt" -> new CmpV(this.info, arg1, arg2, CmpOp.GT);
            case "ge" -> new CmpV(this.info, arg1, arg2, CmpOp.GE);
            case "ne" -> new CmpV(this.info, arg1, arg2, CmpOp.NE);
            case "<<", "precedes" -> new CmpN(this.info, arg1, arg2, CmpOp.LT);
            case ">>", "follows" -> new CmpN(this.info, arg1, arg2, CmpOp.GT);
            case "is" -> new CmpN(this.info, arg1, arg2, CmpOp.EQ);
            case "is-not" -> new CmpN(this.info, arg1, arg2, CmpOp.NE);
            case "precedes-or-is" -> new CmpN(this.info, arg1, arg2, CmpOp.LE);
            case "follows-or-is" -> new CmpN(this.info, arg1, arg2, CmpOp.GE);
            case "||" -> new Concat(this.info, arg1, arg2);
            case "|", "union" -> new Union(this.info, arg1, arg2);
            case "except" -> new Except(this.info, arg1, arg2);
            case "intersect" -> new Intersect(this.info, arg1, arg2);
            case "to" -> new Range(this.info, arg1, arg2);
            case "otherwise" -> new Otherwise(this.info, arg1, arg2);
            default -> throw QueryError.UNKNOWNOP_X.get(this.info, operator);
        };
        FuncType ft = FuncType.get(((Expr)body).seqType(), Types.ITEM_ZM, Types.ITEM_ZM);
        return new FuncItem(this.info, body, params, AnnList.EMPTY, ft, 2, null);
    }
}

