/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.log;

import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IOFile;
import org.basex.query.QueryTracer;
import org.basex.util.DateTime;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.log.LogEntry;
import org.basex.util.log.LogFile;
import org.basex.util.log.LogTarget;
import org.basex.util.log.LogType;
import org.basex.util.options.StringOption;

public final class Log
implements QueryTracer {
    private static final String SERVER = "SERVER";
    private final StaticOptions sopts;
    private final Pattern exclude;
    private final Pattern cut;
    private final HashMap<String, Long> cache = new HashMap();
    private final boolean maskip;
    private final int maxLen;
    private Set<LogTarget> targets;
    LogFile file;

    public Log(StaticOptions sopts) {
        this.sopts = sopts;
        Function<StringOption, Pattern> pattern = option -> {
            String value = sopts.get((StringOption)option);
            try {
                return value.isEmpty() ? null : Pattern.compile(value);
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
                Util.errln("Invalid % pattern: %", option, value);
                return null;
            }
        };
        this.exclude = pattern.apply(StaticOptions.LOGEXCLUDE);
        this.cut = pattern.apply(StaticOptions.LOGCUT);
        this.maxLen = sopts.get(StaticOptions.LOGMSGMAXLEN);
        this.maskip = sopts.get(StaticOptions.LOGMASKIP);
    }

    public LogFile file(String name) {
        LogFile lf = this.file;
        if (lf == null || !lf.valid(name)) {
            lf = new LogFile(name, this.dir());
        }
        return lf.exists() ? lf : null;
    }

    public void writeServer(LogType type, String info) {
        this.write((Object)type, info, null, null, (String)null);
    }

    public void write(Object type, String info, Performance perf, Context ctx) {
        this.write(type, info, perf, ctx.clientAddress(), ctx);
    }

    public void write(Object type, String info, Performance perf, String address, Context ctx) {
        this.write(type, info, perf, address, ctx.clientName());
    }

    private synchronized void write(Object type, String info, Performance perf, String address, String user) {
        String addr;
        int len;
        Object inf;
        if (this.noTargets()) {
            return;
        }
        Object object = inf = info != null ? info.trim().replaceAll("\\s+", " ") : "";
        if (this.exclude(type, (String)inf, address)) {
            return;
        }
        if (this.cut != null) {
            inf = this.cut.matcher((CharSequence)inf).replaceAll("");
        }
        if ((len = ((String)inf).codePointCount(0, ((String)inf).length())) > this.maxLen) {
            inf = ((String)inf).substring(0, ((String)inf).offsetByCodePoints(0, this.maxLen)) + "...";
        }
        String string = addr = address != null ? address.replaceFirst("^/", "") : SERVER;
        if (this.maskip) {
            addr = addr.replaceAll("\\.\\d+:", ".0:").replaceAll("(\\w*:\\w*:\\w*)(:\\w*){5}", "$1::");
        }
        LogEntry entry = new LogEntry();
        entry.date = new Date();
        entry.time = DateTime.format(entry.date, DateTime.TIME);
        entry.address = addr;
        entry.user = user != null ? user : "admin";
        entry.type = type.toString();
        entry.info = inf;
        if (perf != null) {
            entry.runtime = perf.toString();
        }
        for (LogTarget target : this.targets) {
            try {
                target.write(this, entry);
            }
            catch (IOException ex) {
                Util.stack(ex);
            }
        }
    }

    private boolean noTargets() {
        if (this.targets == null) {
            String log = this.sopts.get(StaticOptions.LOG);
            EnumSet<LogTarget> set = EnumSet.noneOf(LogTarget.class);
            for (String target : log.trim().toUpperCase(Locale.ENGLISH).split("\\s*,\\s*")) {
                Boolean enable = Strings.toBoolean(target);
                if (enable == null) {
                    for (LogTarget lt : LogTarget.values()) {
                        if (!target.equals(lt.name())) continue;
                        set.add(lt);
                    }
                    continue;
                }
                if (enable.booleanValue()) {
                    set.add(LogTarget.DATA);
                    continue;
                }
                set.clear();
                break;
            }
            this.targets = set;
        }
        return this.targets.isEmpty();
    }

    private boolean exclude(Object type, String info, String address) {
        if (this.exclude == null) {
            return false;
        }
        boolean found = this.exclude.matcher(info).find();
        if (address != null && (type == LogType.REQUEST || type == LogType.OK || type == LogType.ERROR || type.toString().matches("\\d+"))) {
            long ms = System.currentTimeMillis();
            boolean cached = this.cache.containsKey(address);
            this.cache.values().removeIf(time -> cached || ms - time >= 3600000L);
            if (cached) {
                return true;
            }
            if (found) {
                this.cache.put(address, ms);
            }
        }
        return found;
    }

    public synchronized void close() {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public IOFile[] files() {
        return this.dir().children(".*\\.log");
    }

    public void write(LogEntry entry) throws IOException {
        String name = DateTime.format(entry.date, DateTime.DATE);
        if (this.file != null && !this.file.valid(name)) {
            this.close();
        }
        if (this.file == null) {
            this.file = LogFile.create(name, this.dir());
        }
        this.file.write(Token.token(String.valueOf(entry) + Prop.NL));
    }

    private IOFile dir() {
        return this.sopts.dbPath(".").resolve(this.sopts.get(StaticOptions.LOGPATH));
    }

    @Override
    public boolean printTrace(String message) {
        this.writeServer(LogType.TRACE, message);
        return false;
    }

    @Override
    public boolean moreTraces(int count) {
        return count <= 100;
    }
}

