/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.seq.Empty;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;

public final class QueryStack {
    private static final int INIT = 32;
    private Value[] values = new Value[32];
    private Var[] vars = new Var[32];
    private int start;
    private int end;

    public int enterFrame(int size) {
        int e = this.end;
        int ne = e + size;
        this.ensureCapacity(ne);
        int s = this.start;
        this.start = e;
        this.end = ne;
        return s;
    }

    public void reuseFrame(int size) {
        int s = this.start;
        this.ensureCapacity(s + size);
        Value[] vls = this.values;
        int e = this.end;
        while (--e >= s) {
            vls[e] = null;
        }
        this.end = s + size;
    }

    public void exitFrame(int fp) {
        int vl;
        int ns;
        int s = this.start;
        Value[] vls = this.values;
        int en = this.end;
        while (--en >= s) {
            vls[en] = null;
        }
        this.end = s;
        this.start = fp;
        for (ns = vl = vls.length; ns > 32 && vl <= ns >> 2; ns >>= 1) {
        }
        if (ns != vl) {
            this.resize(ns);
        }
    }

    public boolean tco(int size) {
        return this.end + (size << 1) > 32;
    }

    private void ensureCapacity(int size) {
        int vl;
        int ns;
        for (ns = vl = this.values.length; size > ns; ns <<= 1) {
        }
        if (ns != vl) {
            this.resize(ns);
        }
    }

    private void resize(int size) {
        int os = this.end;
        Value[] vls = new Value[size];
        Array.copy(this.values, os, vls);
        this.values = vls;
        Var[] vrs = new Var[size];
        Array.copy(this.vars, os, vrs);
        this.vars = vrs;
    }

    public Value get(Var var) {
        int vs = var.slot;
        Empty value = vs == -1 ? null : this.values[this.start + vs];
        return value != null ? value : Empty.UNDEFINED;
    }

    public void set(Var var, Value value, QueryContext qc) throws QueryException {
        int pos = this.start + var.slot;
        this.vars[pos] = var;
        this.values[pos] = var.checkType(value, qc, null);
    }

    public String toString() {
        return new TokenBuilder().add(this.getClass()).add(91).addAll(this.values, ", ").add(93).toString();
    }
}

