/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class SingletonArray
extends XQArray {
    private final Value member;

    SingletonArray(Value member) {
        super(ArrayType.get(member.seqType()));
        this.member = member;
    }

    @Override
    public Value memberAt(long index) {
        return this.member;
    }

    @Override
    public Value items(QueryContext qc) {
        return this.member;
    }

    @Override
    public Iter itemsIter() {
        return this.member.iter();
    }

    @Override
    public long structSize() {
        return 1L;
    }

    @Override
    public XQArray putMember(long pos, Value value, QueryContext qc) {
        return SingletonArray.get(value);
    }

    @Override
    protected XQArray subArr(long pos, long length, QueryContext qc) {
        throw Util.notExpected();
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this.member.atomValue(qc, ii);
    }

    @Override
    public XQArray reverseArray(QueryContext qc) {
        return this;
    }

    @Override
    public XQArray insertMember(long pos, Value value, QueryContext qc) {
        Value first = pos == 0L ? value : this.member;
        Value second = pos == 0L ? this.member : value;
        ArrayType at = (ArrayType)this.type.union(ArrayType.get(value.seqType()));
        return new ArrayBuilder(qc, 2L).add(first).add(second).array(at);
    }

    @Override
    public XQArray removeMember(long pos, QueryContext qc) {
        return SingletonArray.empty();
    }
}

