/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.format.FormatUtil;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenParser;

abstract class FormatParser
extends FormatUtil {
    private final InputInfo info;
    FormatUtil.Case cs;
    byte[] primary;
    int first = -1;
    NumeralType numType = NumeralType.NUMBERING;
    byte[] modifier;
    boolean trad;
    int min;
    int max = Integer.MAX_VALUE;
    int radix = 10;

    FormatParser(InputInfo info) {
        this.info = info;
    }

    byte[] presentation(byte[] pic, byte[] def, boolean date, boolean frac) throws QueryException {
        TokenParser tp = new TokenParser(pic);
        int cp = tp.next();
        if (tp.more()) {
            if (cp == 87 && tp.consume(119)) {
                return pic;
            }
            if (date && cp == 78 && tp.consume(110)) {
                return pic;
            }
        } else if (FormatParser.sequence(cp) != null || cp == 105 || cp == 73 || cp == 119 || cp == 87 || date && (cp == 110 || cp == 78) || cp == 9312 || cp == 9332 || cp == 9352 || cp == KANJI[1]) {
            return pic;
        }
        tp.reset();
        while (this.first == -1 && tp.more()) {
            this.first = this.zeroes(tp.next());
        }
        if (this.first == -1) {
            return def;
        }
        tp.reset();
        boolean gss = true;
        boolean mds = false;
        boolean ods = false;
        while (tp.more()) {
            cp = tp.next();
            int d = this.zeroes(cp);
            if (d != -1) {
                if (ods && frac) {
                    throw QueryError.OPTBEFORE_X.get(this.info, new Object[]{pic});
                }
                if (this.first != d) {
                    throw QueryError.DIFFMAND_X.get(this.info, new Object[]{pic});
                }
                mds = true;
                gss = false;
                continue;
            }
            if (cp == 35) {
                if (mds && !frac) {
                    throw QueryError.OPTAFTER_X.get(this.info, new Object[]{pic});
                }
                ods = true;
                gss = false;
                continue;
            }
            if (!Character.isLetter(cp)) {
                if (gss) {
                    throw QueryError.INVGROUP_X.get(this.info, new Object[]{pic});
                }
                gss = true;
                continue;
            }
            throw QueryError.INVDDPATTERN_X.get(this.info, new Object[]{pic});
        }
        if (gss) {
            throw QueryError.INVGROUP_X.get(this.info, new Object[]{pic});
        }
        return pic;
    }

    public boolean digit(int ch, int zero) {
        return ch >= zero && ch <= zero + 9;
    }

    void finish(byte[] pres) {
        int cp = FormatParser.ch(pres, 0);
        this.cs = this.radix == 10 && (Token.cl(pres, 0) < pres.length || Token.digit(cp)) ? FormatUtil.Case.STANDARD : ((cp & 0x20) == 0 ? FormatUtil.Case.UPPER : FormatUtil.Case.LOWER);
        this.primary = Token.lc(pres);
        if (this.first == -1) {
            this.first = FormatParser.ch(this.primary, 0);
        }
    }

    static enum NumeralType {
        ORDINAL,
        CARDINAL,
        NUMBERING;

    }
}

