/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.rewriter;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.DualReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction20bc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction35c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction3rc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction45cc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction4rcc;
import com.android.tools.smali.dexlib2.iface.reference.CallSiteReference;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodHandleReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodProtoReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.rewriter.Rewriter;
import com.android.tools.smali.dexlib2.rewriter.RewriterUtils;
import com.android.tools.smali.dexlib2.rewriter.Rewriters;
import com.android.tools.smali.util.ExceptionWithContext;
import javax.annotation.Nonnull;

public class InstructionRewriter
implements Rewriter<Instruction> {
    @Nonnull
    protected final Rewriters rewriters;

    public InstructionRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public Instruction rewrite(@Nonnull Instruction instruction) {
        if (instruction instanceof ReferenceInstruction) {
            switch (instruction.getOpcode().format) {
                case Format20bc: {
                    return new RewrittenInstruction20bc((Instruction20bc)instruction);
                }
                case Format21c: {
                    return new RewrittenInstruction21c((Instruction21c)instruction);
                }
                case Format22c: {
                    return new RewrittenInstruction22c((Instruction22c)instruction);
                }
                case Format31c: {
                    return new RewrittenInstruction31c((Instruction31c)instruction);
                }
                case Format35c: {
                    return new RewrittenInstruction35c((Instruction35c)instruction);
                }
                case Format3rc: {
                    return new RewrittenInstruction3rc((Instruction3rc)instruction);
                }
                case Format45cc: {
                    return new RewrittenInstruction45cc((Instruction45cc)instruction);
                }
                case Format4rcc: {
                    return new RewrittenInstruction4rcc((Instruction4rcc)instruction);
                }
            }
            throw new IllegalArgumentException();
        }
        return instruction;
    }

    @Nonnull
    private Reference rewriteReference(int type, @Nonnull Reference reference) {
        switch (type) {
            case 1: {
                return RewriterUtils.rewriteTypeReference(this.rewriters.getTypeRewriter(), (TypeReference)reference);
            }
            case 2: {
                return this.rewriters.getFieldReferenceRewriter().rewrite((FieldReference)reference);
            }
            case 3: {
                return this.rewriters.getMethodReferenceRewriter().rewrite((MethodReference)reference);
            }
            case 0: {
                return reference;
            }
            case 4: {
                return RewriterUtils.rewriteMethodProtoReference(this.rewriters.getTypeRewriter(), (MethodProtoReference)reference);
            }
            case 6: {
                return RewriterUtils.rewriteMethodHandleReference(this.rewriters, (MethodHandleReference)reference);
            }
            case 5: {
                return this.rewriters.getCallSiteReferenceRewriter().rewrite((CallSiteReference)reference);
            }
        }
        throw new ExceptionWithContext("Invalid reference type: %d", type);
    }

    protected class RewrittenInstruction4rcc
    extends BaseRewrittenDualReferenceInstruction<Instruction4rcc>
    implements Instruction4rcc {
        public RewrittenInstruction4rcc(Instruction4rcc instruction) {
            super(InstructionRewriter.this, (DualReferenceInstruction)instruction);
        }

        @Override
        public int getStartRegister() {
            return ((Instruction4rcc)this.instruction).getStartRegister();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction4rcc)this.instruction).getRegisterCount();
        }
    }

    protected class RewrittenInstruction45cc
    extends BaseRewrittenDualReferenceInstruction<Instruction45cc>
    implements Instruction45cc {
        public RewrittenInstruction45cc(Instruction45cc instruction) {
            super(InstructionRewriter.this, (DualReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterC() {
            return ((Instruction45cc)this.instruction).getRegisterC();
        }

        @Override
        public int getRegisterE() {
            return ((Instruction45cc)this.instruction).getRegisterE();
        }

        @Override
        public int getRegisterG() {
            return ((Instruction45cc)this.instruction).getRegisterG();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction45cc)this.instruction).getRegisterCount();
        }

        @Override
        public int getRegisterD() {
            return ((Instruction45cc)this.instruction).getRegisterD();
        }

        @Override
        public int getRegisterF() {
            return ((Instruction45cc)this.instruction).getRegisterF();
        }
    }

    protected static class BaseRewrittenDualReferenceInstruction<T extends DualReferenceInstruction>
    extends BaseRewrittenReferenceInstruction<T>
    implements DualReferenceInstruction {
        final /* synthetic */ InstructionRewriter this$0;

        public BaseRewrittenDualReferenceInstruction(T instruction) {
            this.this$0 = this$0;
            super((InstructionRewriter)this$0, instruction);
        }

        @Override
        @Nonnull
        public Reference getReference2() {
            return this.this$0.rewriteReference(((DualReferenceInstruction)this.instruction).getReferenceType2(), ((DualReferenceInstruction)this.instruction).getReference2());
        }

        @Override
        public int getReferenceType2() {
            return ((DualReferenceInstruction)this.instruction).getReferenceType2();
        }
    }

    protected class RewrittenInstruction3rc
    extends BaseRewrittenReferenceInstruction<Instruction3rc>
    implements Instruction3rc {
        public RewrittenInstruction3rc(Instruction3rc instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getStartRegister() {
            return ((Instruction3rc)this.instruction).getStartRegister();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction3rc)this.instruction).getRegisterCount();
        }
    }

    protected class RewrittenInstruction35c
    extends BaseRewrittenReferenceInstruction<Instruction35c>
    implements Instruction35c {
        public RewrittenInstruction35c(Instruction35c instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterC() {
            return ((Instruction35c)this.instruction).getRegisterC();
        }

        @Override
        public int getRegisterE() {
            return ((Instruction35c)this.instruction).getRegisterE();
        }

        @Override
        public int getRegisterG() {
            return ((Instruction35c)this.instruction).getRegisterG();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction35c)this.instruction).getRegisterCount();
        }

        @Override
        public int getRegisterD() {
            return ((Instruction35c)this.instruction).getRegisterD();
        }

        @Override
        public int getRegisterF() {
            return ((Instruction35c)this.instruction).getRegisterF();
        }
    }

    protected class RewrittenInstruction31c
    extends BaseRewrittenReferenceInstruction<Instruction31c>
    implements Instruction31c {
        public RewrittenInstruction31c(Instruction31c instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction31c)this.instruction).getRegisterA();
        }
    }

    protected class RewrittenInstruction22c
    extends BaseRewrittenReferenceInstruction<Instruction22c>
    implements Instruction22c {
        public RewrittenInstruction22c(Instruction22c instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction22c)this.instruction).getRegisterA();
        }

        @Override
        public int getRegisterB() {
            return ((Instruction22c)this.instruction).getRegisterB();
        }
    }

    protected class RewrittenInstruction21c
    extends BaseRewrittenReferenceInstruction<Instruction21c>
    implements Instruction21c {
        public RewrittenInstruction21c(Instruction21c instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction21c)this.instruction).getRegisterA();
        }
    }

    protected class RewrittenInstruction20bc
    extends BaseRewrittenReferenceInstruction<Instruction20bc>
    implements Instruction20bc {
        public RewrittenInstruction20bc(Instruction20bc instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getVerificationError() {
            return ((Instruction20bc)this.instruction).getVerificationError();
        }
    }

    protected static class BaseRewrittenReferenceInstruction<T extends ReferenceInstruction>
    implements ReferenceInstruction {
        @Nonnull
        protected T instruction;
        final /* synthetic */ InstructionRewriter this$0;

        protected BaseRewrittenReferenceInstruction(T instruction) {
            this.this$0 = this$0;
            this.instruction = instruction;
        }

        @Override
        @Nonnull
        public Reference getReference() {
            return this.this$0.rewriteReference(this.instruction.getReferenceType(), this.instruction.getReference());
        }

        @Override
        public int getReferenceType() {
            return this.instruction.getReferenceType();
        }

        @Override
        public Opcode getOpcode() {
            return this.instruction.getOpcode();
        }

        @Override
        public int getCodeUnits() {
            return this.instruction.getCodeUnits();
        }
    }
}

