/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.util.BinaryDataInputStream;
import java.io.IOException;

public final class ResChunkHeader {
    public static final int SIZE = 8;
    public static final int RES_NULL_TYPE = 0;
    public static final int RES_STRING_POOL_TYPE = 1;
    public static final int RES_TABLE_TYPE = 2;
    public static final int RES_XML_TYPE = 3;
    public static final int RES_XML_FIRST_CHUNK_TYPE = 256;
    public static final int RES_XML_START_NAMESPACE_TYPE = 256;
    public static final int RES_XML_END_NAMESPACE_TYPE = 257;
    public static final int RES_XML_START_ELEMENT_TYPE = 258;
    public static final int RES_XML_END_ELEMENT_TYPE = 259;
    public static final int RES_XML_CDATA_TYPE = 260;
    public static final int RES_XML_LAST_CHUNK_TYPE = 383;
    public static final int RES_XML_RESOURCE_MAP_TYPE = 384;
    public static final int RES_TABLE_PACKAGE_TYPE = 512;
    public static final int RES_TABLE_TYPE_TYPE = 513;
    public static final int RES_TABLE_TYPE_SPEC_TYPE = 514;
    public static final int RES_TABLE_LIBRARY_TYPE = 515;
    public static final int RES_TABLE_OVERLAYABLE_TYPE = 516;
    public static final int RES_TABLE_OVERLAYABLE_POLICY_TYPE = 517;
    public static final int RES_TABLE_STAGED_ALIAS_TYPE = 518;
    public final int type;
    public final int headerSize;
    public final int size;

    public ResChunkHeader(int type, int headerSize, int size) {
        this.type = type;
        this.headerSize = headerSize;
        this.size = size;
    }

    public static ResChunkHeader read(BinaryDataInputStream in) throws IOException {
        int type = in.readUnsignedShort();
        int headerSize = in.readUnsignedShort();
        int size = in.readInt();
        return new ResChunkHeader(type, headerSize, size);
    }

    public static String nameOf(int type) {
        switch (type) {
            case 0: {
                return "RES_NULL_TYPE";
            }
            case 1: {
                return "RES_STRING_POOL_TYPE";
            }
            case 2: {
                return "RES_TABLE_TYPE";
            }
            case 3: {
                return "RES_XML_TYPE";
            }
            case 256: {
                return "RES_XML_START_NAMESPACE_TYPE";
            }
            case 257: {
                return "RES_XML_END_NAMESPACE_TYPE";
            }
            case 258: {
                return "RES_XML_START_ELEMENT_TYPE";
            }
            case 259: {
                return "RES_XML_END_ELEMENT_TYPE";
            }
            case 260: {
                return "RES_XML_CDATA_TYPE";
            }
            case 384: {
                return "RES_XML_RESOURCE_MAP_TYPE";
            }
            case 512: {
                return "RES_TABLE_PACKAGE_TYPE";
            }
            case 513: {
                return "RES_TABLE_TYPE_TYPE";
            }
            case 514: {
                return "RES_TABLE_TYPE_SPEC_TYPE";
            }
            case 515: {
                return "RES_TABLE_LIBRARY_TYPE";
            }
            case 516: {
                return "RES_TABLE_OVERLAYABLE_TYPE";
            }
            case 517: {
                return "RES_TABLE_OVERLAYABLE_POLICY_TYPE";
            }
            case 518: {
                return "RES_TABLE_STAGED_ALIAS_TYPE";
            }
        }
        return String.format("0x%04x", type);
    }
}

