/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.table.ResConfig;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResOverlayable;
import brut.androlib.res.table.ResPackageGroup;
import brut.androlib.res.table.ResTable;
import brut.androlib.res.table.ResType;
import brut.androlib.res.table.ResTypeSpec;
import brut.androlib.res.table.value.ResValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class ResPackage {
    private final ResPackageGroup mGroup;
    private final int mIndex;
    private final Map<Integer, ResTypeSpec> mTypeSpecs;
    private final Map<Pair<Integer, ResConfig>, ResType> mTypes;
    private final Map<ResId, ResEntrySpec> mEntrySpecs;
    private final Map<Pair<ResId, ResConfig>, ResEntry> mEntries;
    private final Map<String, ResOverlayable> mOverlayables;
    private final Map<ResId, ResId> mAliases;
    private final Set<String> mNameRegistry;

    public ResPackage(ResPackageGroup group, int index) {
        assert (group != null && index >= 0);
        this.mGroup = group;
        this.mIndex = index;
        this.mTypeSpecs = new HashMap<Integer, ResTypeSpec>();
        this.mTypes = new HashMap<Pair<Integer, ResConfig>, ResType>();
        this.mEntrySpecs = new HashMap<ResId, ResEntrySpec>();
        this.mEntries = new HashMap<Pair<ResId, ResConfig>, ResEntry>();
        this.mOverlayables = new HashMap<String, ResOverlayable>();
        this.mAliases = new HashMap<ResId, ResId>();
        this.mNameRegistry = new HashSet<String>();
    }

    public ResTable getTable() {
        return this.mGroup.getTable();
    }

    public ResPackageGroup getGroup() {
        return this.mGroup;
    }

    public int getId() {
        return this.mGroup.getId();
    }

    public String getName() {
        return this.mGroup.getName();
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean hasTypeSpec(int typeId) {
        return this.mTypeSpecs.containsKey(typeId);
    }

    public ResTypeSpec getTypeSpec(int typeId) throws UndefinedResObjectException {
        ResTypeSpec typeSpec = this.mTypeSpecs.get(typeId);
        if (typeSpec == null) {
            throw new UndefinedResObjectException(String.format("type spec: pkgId=0x%02x, typeId=0x%02x", this.getId(), typeId));
        }
        return typeSpec;
    }

    public ResTypeSpec addTypeSpec(int typeId, String typeName) throws AndrolibException {
        ResTypeSpec typeSpec = this.mTypeSpecs.get(typeId);
        if (typeSpec != null) {
            throw new AndrolibException(String.format("Repeated type spec: pkgId=0x%02x, typeId=0x%02x, typeName=%s", this.getId(), typeId, typeName));
        }
        typeSpec = new ResTypeSpec(this, typeId, typeName);
        this.mTypeSpecs.put(typeId, typeSpec);
        return typeSpec;
    }

    public int getTypeSpecCount() {
        return this.mTypeSpecs.size();
    }

    public Collection<ResTypeSpec> listTypeSpecs() {
        return this.mTypeSpecs.values();
    }

    public boolean hasType(int typeId) {
        return this.hasType(typeId, ResConfig.DEFAULT);
    }

    public boolean hasType(int typeId, ResConfig config) {
        Pair<Integer, ResConfig> typeKey = Pair.of(typeId, config);
        return this.mTypes.containsKey(typeKey);
    }

    public ResType getType(int typeId) throws UndefinedResObjectException {
        return this.getType(typeId, ResConfig.DEFAULT);
    }

    public ResType getType(int typeId, ResConfig config) throws UndefinedResObjectException {
        Pair<Integer, ResConfig> typeKey = Pair.of(typeId, config);
        ResType type = this.mTypes.get(typeKey);
        if (type == null) {
            throw new UndefinedResObjectException(String.format("type: pkgId=0x%02x, typeId=0x%02x, config=%s", this.getId(), typeId, config));
        }
        return type;
    }

    public ResType addType(int typeId) throws UndefinedResObjectException {
        return this.addType(typeId, ResConfig.DEFAULT);
    }

    public ResType addType(int typeId, ResConfig config) throws UndefinedResObjectException {
        Pair<Integer, ResConfig> typeKey = Pair.of(typeId, config);
        ResType type = this.mTypes.get(typeKey);
        if (type != null) {
            return type;
        }
        ResTypeSpec typeSpec = this.getTypeSpec(typeId);
        type = new ResType(typeSpec, config);
        this.mTypes.put(typeKey, type);
        return type;
    }

    public int getTypeCount() {
        return this.mTypes.size();
    }

    public Collection<ResType> listTypes() {
        return this.mTypes.values();
    }

    public boolean hasEntrySpec(int typeId, int entryId) {
        ResId resId = ResId.of(this.getId(), typeId, entryId);
        resId = this.mAliases.getOrDefault(resId, resId);
        return this.mEntrySpecs.containsKey(resId);
    }

    public ResEntrySpec getEntrySpec(int typeId, int entryId) throws UndefinedResObjectException {
        ResEntrySpec entrySpec;
        ResId resId = ResId.of(this.getId(), typeId, entryId);
        if (this.mAliases.containsKey(resId)) {
            resId = this.mAliases.get(resId);
            typeId = resId.typeId();
            entryId = resId.entryId();
        }
        if ((entrySpec = this.mEntrySpecs.get(resId)) == null) {
            throw new UndefinedResObjectException(String.format("entry spec: pkgId=0x%02x, typeId=0x%02x, entryId=0x%04x", this.getId(), typeId, entryId));
        }
        return entrySpec;
    }

    public ResEntrySpec addEntrySpec(int typeId, int entryId, String name) throws AndrolibException {
        ResEntrySpec entrySpec;
        ResId resId = ResId.of(this.getId(), typeId, entryId);
        if (this.mAliases.containsKey(resId)) {
            resId = this.mAliases.get(resId);
            typeId = resId.typeId();
            entryId = resId.entryId();
        }
        if ((entrySpec = this.mEntrySpecs.get(resId)) != null) {
            throw new AndrolibException(String.format("Repeated entry spec: pkgId=0x%02x, typeId=0x%02x, entryId=0x%04x", this.getId(), typeId, entryId));
        }
        ResTypeSpec typeSpec = this.getTypeSpec(typeId);
        if (this.mNameRegistry.contains(typeSpec.getName() + "/" + name)) {
            name = "";
        }
        entrySpec = new ResEntrySpec(typeSpec, entryId, name);
        this.mEntrySpecs.put(resId, entrySpec);
        this.mNameRegistry.add(typeSpec.getName() + "/" + entrySpec.getName());
        return entrySpec;
    }

    public int getEntrySpecCount() {
        return this.mEntrySpecs.size();
    }

    public Collection<ResEntrySpec> listEntrySpecs() {
        return this.mEntrySpecs.values();
    }

    public boolean hasEntry(int typeId, int entryId) {
        return this.hasEntry(typeId, entryId, ResConfig.DEFAULT);
    }

    public boolean hasEntry(int typeId, int entryId, ResConfig config) {
        ResId resId = ResId.of(this.getId(), typeId, entryId);
        resId = this.mAliases.getOrDefault(resId, resId);
        Pair<ResId, ResConfig> entryKey = Pair.of(resId, config);
        return this.mEntries.containsKey(entryKey);
    }

    public ResEntry getEntry(int typeId, int entryId) throws UndefinedResObjectException {
        return this.getEntry(typeId, entryId, ResConfig.DEFAULT);
    }

    public ResEntry getEntry(int typeId, int entryId, ResConfig config) throws UndefinedResObjectException {
        Pair<ResId, ResConfig> entryKey;
        ResEntry entry;
        ResId resId = ResId.of(this.getId(), typeId, entryId);
        if (this.mAliases.containsKey(resId)) {
            resId = this.mAliases.get(resId);
            typeId = resId.typeId();
            entryId = resId.entryId();
        }
        if ((entry = this.mEntries.get(entryKey = Pair.of(resId, config))) == null) {
            throw new UndefinedResObjectException(String.format("entry: pkgId=0x%02x, typeId=0x%02x, entryId=0x%04x, config=%s", this.getId(), typeId, entryId, config));
        }
        return entry;
    }

    public ResEntry addEntry(int typeId, int entryId, ResValue value) throws AndrolibException {
        return this.addEntry(typeId, entryId, ResConfig.DEFAULT, value);
    }

    public ResEntry addEntry(int typeId, int entryId, ResConfig config, ResValue value) throws AndrolibException {
        Pair<ResId, ResConfig> entryKey;
        ResEntry entry;
        ResId resId = ResId.of(this.getId(), typeId, entryId);
        if (this.mAliases.containsKey(resId)) {
            resId = this.mAliases.get(resId);
            typeId = resId.typeId();
            entryId = resId.entryId();
        }
        if ((entry = this.mEntries.get(entryKey = Pair.of(resId, config))) != null) {
            throw new AndrolibException(String.format("Repeated entry: pkgId=0x%02x, typeId=0x%02x, entryId=0x%04x, config=%s", this.getId(), typeId, entryId, config));
        }
        ResEntrySpec entrySpec = this.getEntrySpec(typeId, entryId);
        Pair<Integer, ResConfig> typeKey = Pair.of(typeId, config);
        ResType type = this.mTypes.get(typeKey);
        if (type == null) {
            ResTypeSpec typeSpec = this.getTypeSpec(typeId);
            type = new ResType(typeSpec, config);
            this.mTypes.put(typeKey, type);
        }
        entry = new ResEntry(type, entrySpec, value);
        this.mEntries.put(entryKey, entry);
        return entry;
    }

    public int getEntryCount() {
        return this.mEntries.size();
    }

    public Collection<ResEntry> listEntries() {
        return this.mEntries.values();
    }

    public boolean hasOverlayable(String name) {
        return this.mOverlayables.containsKey(name);
    }

    public ResOverlayable getOverlayable(String name) throws UndefinedResObjectException {
        ResOverlayable overlayable = this.mOverlayables.get(name);
        if (overlayable == null) {
            throw new UndefinedResObjectException(String.format("overlayable: pkgId=0x%02x, name=%s", this.getId(), name));
        }
        return overlayable;
    }

    public ResOverlayable addOverlayable(String name, String actor) throws AndrolibException {
        ResOverlayable overlayable = this.mOverlayables.get(name);
        if (overlayable != null) {
            throw new AndrolibException(String.format("Repeated overlayable: pkgId=0x%02x, name=%s", this.getId(), name));
        }
        overlayable = new ResOverlayable(this, name, actor);
        this.mOverlayables.put(name, overlayable);
        return overlayable;
    }

    public int getOverlayableCount() {
        return this.mOverlayables.size();
    }

    public Collection<ResOverlayable> listOverlayables() {
        return this.mOverlayables.values();
    }

    public boolean isAlias(ResId resId) {
        return this.mAliases.containsKey(resId);
    }

    public ResId resolveAlias(ResId aliasId) throws UndefinedResObjectException {
        ResId resId = this.mAliases.get(aliasId);
        if (resId == null) {
            throw new UndefinedResObjectException(String.format("alias: pkgId=0x%02x, aliasId=%s", this.getId(), aliasId));
        }
        return resId;
    }

    public void addAlias(ResId aliasId, ResId finalId) throws AndrolibException {
        if (this.mAliases.containsKey(aliasId)) {
            throw new AndrolibException(String.format("Repeated alias: pkgId=0x%02x, aliasId=%s", this.getId(), aliasId));
        }
        this.mAliases.put(aliasId, finalId);
    }

    public int getAliasCount() {
        return this.mAliases.size();
    }

    public Map<ResId, ResId> getAliases() {
        return this.mAliases;
    }

    public String toString() {
        return String.format("ResPackage{id=0x%02x, name=%s}", this.getId(), this.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResPackage) {
            ResPackage other = (ResPackage)obj;
            return this.mGroup.equals(other.mGroup) && this.mIndex == other.mIndex;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mGroup, this.mIndex);
    }
}

