/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ImmutableConverter<ImmutableItem, Item> {
    protected abstract boolean isImmutable(@Nonnull Item var1);

    @Nonnull
    protected abstract ImmutableItem makeImmutable(@Nonnull Item var1);

    @Nonnull
    public List<ImmutableItem> toList(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        boolean needsCopy = false;
        if (iterable instanceof List) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return Collections.unmodifiableList((List)iterable);
        }
        Iterator<Item> iter = iterable.iterator();
        ArrayList<ImmutableItem> list = new ArrayList<ImmutableItem>();
        while (iter.hasNext()) {
            list.add(this.makeImmutable(iter.next()));
        }
        return Collections.unmodifiableList(list);
    }

    @Nonnull
    public Set<ImmutableItem> toSet(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return Collections.emptySet();
        }
        boolean needsCopy = false;
        if (iterable instanceof Set) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return Collections.unmodifiableSet((Set)iterable);
        }
        Iterator<Item> iter = iterable.iterator();
        HashSet<ImmutableItem> set = new HashSet<ImmutableItem>();
        while (iter.hasNext()) {
            set.add(this.makeImmutable(iter.next()));
        }
        return Collections.unmodifiableSet(set);
    }

    @Nonnull
    public SortedSet<ImmutableItem> toSortedSet(@Nonnull Comparator<? super ImmutableItem> comparator, @Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return Collections.emptySortedSet();
        }
        boolean needsCopy = false;
        if (iterable instanceof SortedSet && ((SortedSet)iterable).comparator().equals(comparator)) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return Collections.unmodifiableSortedSet((SortedSet)iterable);
        }
        Iterator<Item> iter = iterable.iterator();
        TreeSet<ImmutableItem> treeSet = new TreeSet<ImmutableItem>(comparator);
        while (iter.hasNext()) {
            treeSet.add(this.makeImmutable(iter.next()));
        }
        return Collections.unmodifiableSortedSet(treeSet);
    }
}

