/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResAttribute;
import brut.androlib.res.table.value.ResCustom;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResReference;
import brut.common.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class ResFlags
extends ResAttribute {
    private static final String TAG = ResFlags.class.getName();
    private final ResAttribute.Symbol[] mSymbols;
    private Map<Integer, ResAttribute.Symbol[]> mSymbolsCache;
    private Map<Integer, String> mFormatsCache;
    private ResAttribute.Symbol[] mSortedSymbols;

    public ResFlags(ResReference parent, int type, int min, int max, int l10n, ResAttribute.Symbol[] symbols) {
        super(parent, type, min, max, l10n);
        assert (parent != null && symbols != null);
        this.mSymbols = symbols;
    }

    @Override
    public void resolveKeys() throws AndrolibException {
        ResPackage pkg = this.mParent.getPackage();
        boolean skipUnresolved = pkg.getTable().getConfig().isDecodeResolveLazy();
        for (ResAttribute.Symbol symbol : this.mSymbols) {
            ResReference key = symbol.getKey();
            if (key.resolve() != null) continue;
            ResId keyId = key.getResId();
            if (skipUnresolved || keyId.pkgId() != pkg.getId()) {
                Log.w(TAG, "Unresolved flag reference: key=%s, value=%s", key, symbol.getValue());
                continue;
            }
            pkg.addEntrySpec(keyId.typeId(), keyId.entryId(), "APKTOOL_DUMMY_" + keyId);
            pkg.addEntry(keyId.typeId(), keyId.entryId(), ResCustom.ID);
        }
    }

    @Override
    protected ResAttribute.Symbol[] getSymbolsForValue(ResItem value) {
        if (!this.isSymbolValueType(value)) {
            return null;
        }
        int data = ((ResPrimitive)value).getData();
        return this.getSymbols(data);
    }

    private boolean isSymbolValueType(ResItem value) {
        if (!(value instanceof ResPrimitive)) {
            return false;
        }
        int type = value.getType();
        return type == 16 || type == 17;
    }

    private ResAttribute.Symbol[] getSymbols(int data) {
        if (this.mSymbolsCache == null) {
            this.mSymbolsCache = new HashMap<Integer, ResAttribute.Symbol[]>();
        } else if (this.mSymbolsCache.containsKey(data)) {
            return this.mSymbolsCache.get(data);
        }
        if (this.mSortedSymbols == null) {
            this.mSortedSymbols = (ResAttribute.Symbol[])this.mSymbols.clone();
            Comparator<ResAttribute.Symbol> byBitCount = Comparator.comparingInt(symbol -> Integer.bitCount(symbol.getValue().getData()));
            Comparator<ResAttribute.Symbol> byRawValue = Comparator.comparingInt(symbol -> symbol.getValue().getData());
            Arrays.sort(this.mSortedSymbols, byBitCount.reversed().thenComparing(byRawValue));
        }
        ResAttribute.Symbol[] symbols = new ResAttribute.Symbol[this.mSortedSymbols.length];
        int symbolsCount = 0;
        if (data == 0) {
            for (ResAttribute.Symbol symbol2 : this.mSortedSymbols) {
                if (symbol2.getValue().getData() != 0) continue;
                symbols[symbolsCount++] = symbol2;
            }
        } else {
            int mask = 0;
            for (ResAttribute.Symbol symbol3 : this.mSortedSymbols) {
                int flag = symbol3.getValue().getData();
                if ((data & flag) != flag || (mask & flag) == flag) continue;
                symbols[symbolsCount++] = symbol3;
                if ((mask |= flag) == data) break;
            }
            if (symbolsCount > 2) {
                ResAttribute.Symbol[] filtered = new ResAttribute.Symbol[symbolsCount];
                int filteredCount = 0;
                for (int i = 0; i < symbolsCount; ++i) {
                    ResAttribute.Symbol symbol3;
                    symbol3 = symbols[i];
                    mask = 0;
                    for (int j = 0; j < symbolsCount; ++j) {
                        ResAttribute.Symbol other = symbols[j];
                        if (j == i) continue;
                        mask |= other.getValue().getData();
                    }
                    if ((symbol3.getValue().getData() & ~mask) == 0) continue;
                    filtered[filteredCount++] = symbol3;
                }
                symbols = filtered;
                symbolsCount = filteredCount;
            }
        }
        if (symbolsCount == 0) {
            symbols = null;
        } else if (symbolsCount < symbols.length) {
            symbols = Arrays.copyOf(symbols, symbolsCount);
        }
        this.mSymbolsCache.put(data, symbols);
        return symbols;
    }

    @Override
    protected String formatValueFromSymbols(ResItem value) throws AndrolibException {
        if (!this.isSymbolValueType(value)) {
            return null;
        }
        int data = ((ResPrimitive)value).getData();
        if (this.mFormatsCache == null) {
            this.mFormatsCache = new HashMap<Integer, String>();
        } else if (this.mFormatsCache.containsKey(data)) {
            return this.mFormatsCache.get(data);
        }
        ResAttribute.Symbol[] symbols = this.getSymbols(data);
        String formatted = null;
        if (symbols != null) {
            StringBuilder sb = new StringBuilder();
            for (ResAttribute.Symbol symbol : symbols) {
                ResEntrySpec keySpec = symbol.getKey().resolve();
                if (keySpec == null) continue;
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(keySpec.getName());
            }
            formatted = sb.toString();
        }
        this.mFormatsCache.put(data, formatted);
        return formatted;
    }

    @Override
    protected void serializeSymbolsToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        for (ResAttribute.Symbol symbol : this.mSymbols) {
            ResEntrySpec keySpec = symbol.getKey().resolve();
            if (keySpec == null) continue;
            serial.startTag(null, "flag");
            serial.attribute(null, "name", keySpec.getName());
            serial.attribute(null, "value", symbol.getValue().toXmlAttributeValue());
            serial.endTag(null, "flag");
        }
    }

    @Override
    public String toString() {
        return String.format("ResFlags{parent=%s, type=0x%04x, min=%s, max=%s, l10n=%s, symbols=%s}", this.mParent, this.mType, this.mMin, this.mMax, this.mL10n, Arrays.toString(this.mSymbols));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResFlags) {
            ResFlags other = (ResFlags)obj;
            return this.mParent.equals(other.mParent) && this.mType == other.mType && this.mMin == other.mMin && this.mMax == other.mMax && this.mL10n == other.mL10n && Arrays.equals(this.mSymbols, other.mSymbols);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mParent, this.mType, this.mMin, this.mMax, this.mL10n, Arrays.hashCode(this.mSymbols));
    }
}

