/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.util.BinaryDataInputStream;
import java.io.IOException;

public final class NinePatchData {
    public static final int MAGIC = 1852855395;
    public static final int COLOR_TICK = -16777216;
    public final int[] xDivs;
    public final int[] yDivs;
    public final int paddingLeft;
    public final int paddingRight;
    public final int paddingTop;
    public final int paddingBottom;

    public NinePatchData(int[] xDivs, int[] yDivs, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        this.xDivs = xDivs;
        this.yDivs = yDivs;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
    }

    public static NinePatchData read(BinaryDataInputStream in) throws IOException {
        in.skipByte();
        int numXDivs = in.readUnsignedByte();
        int numYDivs = in.readUnsignedByte();
        in.skipByte();
        in.skipInt();
        in.skipInt();
        int paddingLeft = in.readInt();
        int paddingRight = in.readInt();
        int paddingTop = in.readInt();
        int paddingBottom = in.readInt();
        in.skipInt();
        int[] xDivs = in.readIntArray(numXDivs);
        int[] yDivs = in.readIntArray(numYDivs);
        return new NinePatchData(xDivs, yDivs, paddingLeft, paddingRight, paddingTop, paddingBottom);
    }
}

