/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.value.ResArray;
import brut.androlib.res.table.value.ResAttribute;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResPlural;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResStyle;
import brut.androlib.res.table.value.ResValue;
import brut.androlib.res.xml.ValuesXmlSerializable;
import brut.common.Log;

public abstract class ResBag
extends ResValue
implements ValuesXmlSerializable {
    private static final String TAG = ResBag.class.getName();
    protected final ResReference mParent;

    protected ResBag(ResReference parent) {
        this.mParent = parent;
    }

    public static ResBag parse(String typeName, ResReference parent, RawItem[] rawItems) {
        switch (typeName) {
            case "attr": 
            case "^attr-private": {
                return ResAttribute.parse(parent, rawItems);
            }
            case "array": {
                return ResArray.parse(parent, rawItems);
            }
            case "plurals": {
                return ResPlural.parse(parent, rawItems);
            }
            case "style": {
                return ResStyle.parse(parent, rawItems);
            }
        }
        Log.w(TAG, "Unsupported type for bags: " + typeName);
        return null;
    }

    public void resolveKeys() throws AndrolibException {
    }

    public static class RawItem {
        private final int mKey;
        private final ResItem mValue;

        public RawItem(int key, ResItem value) {
            assert (value != null);
            this.mKey = key;
            this.mValue = value;
        }

        public int getKey() {
            return this.mKey;
        }

        public ResItem getValue() {
            return this.mValue;
        }
    }
}

