/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResStringPool;
import brut.androlib.res.decoder.ResChunkPullParser;
import brut.androlib.res.table.ResConfig;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResOverlayable;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResTable;
import brut.androlib.res.table.ResType;
import brut.androlib.res.table.ResTypeSpec;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResCustom;
import brut.androlib.res.table.value.ResFileReference;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResString;
import brut.androlib.res.table.value.ResValue;
import brut.common.Log;
import brut.util.BinaryDataInputStream;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;

public class BinaryResourceParser {
    private static final String TAG = BinaryResourceParser.class.getName();
    private static final int NO_ENTRY = -1;
    private static final int NO_ENTRY_OFFSET16 = 65535;
    private static final int SPEC_FLAG_PUBLIC = 0x40000000;
    private static final int SPEC_FLAG_STAGED_API = 0x20000000;
    private static final int TYPE_FLAG_SPARSE = 1;
    private static final int TYPE_FLAG_OFFSET16 = 2;
    private static final int ENTRY_FLAG_COMPLEX = 1;
    private static final int ENTRY_FLAG_PUBLIC = 2;
    private static final int ENTRY_FLAG_WEAK = 4;
    private static final int ENTRY_FLAG_COMPACT = 8;
    private static final int ENTRY_FLAG_FEATUREFLAG = 16;
    private final ResTable mTable;
    private final boolean mKeepBrokenResources;
    private final boolean mAllowDummyEntrySpecs;
    private final Set<ResId> mMissingEntrySpecs;
    private final Set<ResConfig> mInvalidConfigs;
    private BinaryDataInputStream mIn;
    private ResStringPool mValueStringPool;
    private int mPackageCount;
    private ResPackage mPackage;
    private int mTypeIdOffset;
    private ResStringPool mTypeStringPool;
    private ResStringPool mKeyStringPool;
    private boolean mSparseEntries;
    private boolean mCompactEntries;
    private List<Pair<Long, Integer>> mEntrySpecFlagsOffsets;

    public BinaryResourceParser(ResTable table, boolean keepBrokenResources, boolean allowDummyEntrySpecs) {
        this.mTable = table;
        this.mKeepBrokenResources = keepBrokenResources;
        this.mAllowDummyEntrySpecs = allowDummyEntrySpecs;
        this.mMissingEntrySpecs = new HashSet<ResId>();
        this.mInvalidConfigs = new HashSet<ResConfig>();
    }

    public boolean isSparseEntries() {
        return this.mSparseEntries;
    }

    public boolean isCompactEntries() {
        return this.mCompactEntries;
    }

    public void enableCollectFlagsOffsets() {
        this.mEntrySpecFlagsOffsets = new ArrayList<Pair<Long, Integer>>();
    }

    public Collection<Pair<Long, Integer>> getEntrySpecFlagsOffsets() {
        return this.mEntrySpecFlagsOffsets;
    }

    public void parse(InputStream in) throws AndrolibException {
        this.reset();
        this.mIn = new BinaryDataInputStream(in);
        ResChunkPullParser parser = new ResChunkPullParser(this.mIn);
        try {
            if (!this.nextChunk(parser)) {
                throw new AndrolibException("Input file is empty.");
            }
            if (parser.chunkType() != 2) {
                throw new AndrolibException("Unexpected chunk: " + parser.chunkName() + " (expected: RES_TABLE_TYPE)");
            }
            this.parseTable(parser);
            Log.d(TAG, "End of chunks at 0x%08x", this.mIn.position());
            if (this.mIn.available() > 0) {
                Log.d(TAG, "Ignoring trailing data at 0x%08x.", this.mIn.position());
            }
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not decode arsc file.", ex);
        }
    }

    public void reset() {
        this.mIn = null;
        this.mMissingEntrySpecs.clear();
        this.mInvalidConfigs.clear();
        this.mValueStringPool = null;
        this.mPackageCount = 0;
        this.mPackage = null;
        this.mTypeIdOffset = 0;
        this.mTypeStringPool = null;
        this.mKeyStringPool = null;
        this.mSparseEntries = false;
        this.mCompactEntries = false;
        if (this.mEntrySpecFlagsOffsets != null) {
            this.mEntrySpecFlagsOffsets.clear();
        }
    }

    private boolean nextChunk(ResChunkPullParser parser) throws IOException {
        int skipped;
        if (parser.isChunk() && (skipped = parser.skipChunk()) > 0) {
            Log.d(TAG, "Skipped unknown %s bytes at end of %s chunk.", skipped, parser.chunkName());
        }
        while (parser.next()) {
            if (parser.chunkType() == 0) {
                Log.d(TAG, "Skipping unknown chunk (%s) of %s bytes at 0x%08x.", parser.chunkName(), parser.chunkSize(), parser.chunkStart());
                parser.skipChunk();
                continue;
            }
            Log.d(TAG, "Chunk at 0x%08x: %s (%s bytes)", parser.chunkStart(), parser.chunkName(), parser.chunkSize());
            return true;
        }
        return false;
    }

    private void parseTable(ResChunkPullParser parser) throws AndrolibException, IOException {
        int packageCount = this.mIn.readInt();
        this.skipUnreadHeader(parser);
        parser = new ResChunkPullParser(this.mIn, parser.dataSize());
        block4: while (this.nextChunk(parser)) {
            switch (parser.chunkType()) {
                case 1: {
                    this.parseStringPool(parser);
                    continue block4;
                }
                case 512: {
                    this.parsePackage(parser);
                    continue block4;
                }
            }
            this.skipUnexpectedChunk(parser);
        }
        if (this.mPackageCount != packageCount) {
            Log.w(TAG, "Unexpected package count: %s (expected: %s)", this.mPackageCount, packageCount);
        }
    }

    private void parseStringPool(ResChunkPullParser parser) throws AndrolibException, IOException {
        ResStringPool stringPool = ResStringPool.parse(parser);
        if (this.mValueStringPool == null) {
            this.mValueStringPool = stringPool;
        } else if (this.mTypeStringPool == null) {
            this.mTypeStringPool = stringPool;
        } else if (this.mKeyStringPool == null) {
            this.mKeyStringPool = stringPool;
        } else {
            this.skipUnexpectedChunk(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePackage(ResChunkPullParser parser) throws AndrolibException, IOException {
        int id = this.mIn.readInt();
        String name = this.mIn.readUtf16(128);
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        if (parser.headerSize() >= 288) {
            this.mTypeIdOffset = this.mIn.readInt();
            if (this.mTypeIdOffset > 0) {
                Log.w(TAG, "Please report this app here: https://github.com/iBotPeaches/Apktool/issues/1728");
            }
        } else {
            this.mTypeIdOffset = 0;
        }
        this.skipUnreadHeader(parser);
        try {
            this.mPackage = this.mTable.getPackageGroup(id).addSubPackage();
        }
        catch (UndefinedResObjectException ignored) {
            this.mPackage = this.mTable.addPackageGroup(id, name).getBasePackage();
        }
        finally {
            ++this.mPackageCount;
        }
        parser = new ResChunkPullParser(this.mIn, parser.dataSize());
        block13: while (this.nextChunk(parser)) {
            switch (parser.chunkType()) {
                case 1: {
                    this.parseStringPool(parser);
                    continue block13;
                }
                case 514: {
                    this.parseTypeSpec(parser);
                    continue block13;
                }
                case 513: {
                    this.parseType(parser);
                    continue block13;
                }
                case 515: {
                    this.parseLibrary(parser);
                    continue block13;
                }
                case 516: {
                    this.parseOverlayable(parser);
                    continue block13;
                }
                case 518: {
                    this.parseStagedAliases(parser);
                    continue block13;
                }
            }
            this.skipUnexpectedChunk(parser);
        }
        this.injectDummyEntrySpecs();
        this.mInvalidConfigs.clear();
        this.mPackage = null;
        this.mTypeIdOffset = 0;
        this.mTypeStringPool = null;
        this.mKeyStringPool = null;
    }

    private void parseTypeSpec(ResChunkPullParser parser) throws AndrolibException, IOException {
        if (this.mTypeStringPool == null) {
            throw new AndrolibException("Missing type string pool.");
        }
        int id = this.mIn.readUnsignedByte();
        this.mIn.skipByte();
        this.mIn.skipShort();
        int entryCount = this.mIn.readInt();
        this.skipUnreadHeader(parser);
        if (this.mEntrySpecFlagsOffsets != null) {
            this.mEntrySpecFlagsOffsets.add(Pair.of(this.mIn.position(), entryCount));
        }
        this.mIn.skipBytes(entryCount * 4);
        this.mPackage.addTypeSpec(id, this.mTypeStringPool.getString(id - 1));
    }

    private void parseType(ResChunkPullParser parser) throws AndrolibException, IOException {
        boolean isSparse;
        ResType type;
        ResTypeSpec typeSpec;
        if (this.mTypeStringPool == null) {
            throw new AndrolibException("Missing type string pool.");
        }
        if (this.mKeyStringPool == null) {
            throw new AndrolibException("Missing key string pool");
        }
        int id = this.mIn.readUnsignedByte() - this.mTypeIdOffset;
        int flags = this.mIn.readUnsignedByte();
        this.mIn.skipShort();
        int entryCount = this.mIn.readInt();
        int entriesStart = this.mIn.readInt();
        ResConfig config = this.parseConfig();
        this.skipUnreadHeader(parser);
        try {
            typeSpec = this.mPackage.getTypeSpec(id);
        }
        catch (UndefinedResObjectException ignored) {
            typeSpec = this.mPackage.addTypeSpec(id, this.mTypeStringPool.getString(id - 1));
        }
        String typeName = typeSpec.getName();
        if (this.mInvalidConfigs.contains(config)) {
            if (this.mKeepBrokenResources) {
                Log.w(TAG, "Invalid resource config detected: %s %s", typeName, config);
                type = this.mPackage.addType(id, config);
            } else {
                Log.w(TAG, "Invalid resource config detected. Dropping resources: %s %s", typeName, config);
                type = null;
            }
        } else {
            type = this.mPackage.addType(id, config);
        }
        boolean isOffset16 = (flags & 2) != 0;
        boolean bl = isSparse = (flags & 1) != 0;
        if (isSparse) {
            this.mSparseEntries = true;
        }
        TreeMap<Integer, ArrayList<Integer>> entryOffsets = new TreeMap<Integer, ArrayList<Integer>>();
        for (int i = 0; i < entryCount; ++i) {
            int offset;
            int index;
            if (isSparse) {
                index = this.mIn.readUnsignedShort();
                offset = this.mIn.readUnsignedShort() * 4;
            } else {
                index = i;
                offset = isOffset16 ? ((offset = this.mIn.readUnsignedShort()) == 65535 ? -1 : offset * 4) : this.mIn.readInt();
            }
            ArrayList<Integer> indexes = (ArrayList<Integer>)entryOffsets.get(offset);
            if (indexes == null) {
                indexes = new ArrayList<Integer>();
                entryOffsets.put(offset, indexes);
            }
            indexes.add(index);
        }
        List indexes = (List)entryOffsets.get(-1);
        if (indexes != null) {
            if (type != null) {
                Iterator iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    if (this.mPackage.hasEntrySpec(id, index)) continue;
                    this.mMissingEntrySpecs.add(ResId.of(this.mPackage.getId(), id, index));
                }
            }
            entryOffsets.remove(-1);
            entryCount -= indexes.size();
        }
        for (Map.Entry entryOffset : entryOffsets.entrySet()) {
            int offset = (Integer)entryOffset.getKey();
            indexes = (List)entryOffset.getValue();
            long entryStart = parser.chunkStart() + (long)entriesStart + (long)offset;
            if (entryStart >= parser.chunkEnd()) {
                Log.w(TAG, "End of chunk hit. Skipping remaining %s entries in type: %s", entryCount, typeName);
                break;
            }
            this.mIn.jumpTo(entryStart);
            Pair<Integer, ResValue> entry = this.parseEntry(typeName);
            int key = entry.getLeft();
            ResValue value = entry.getRight();
            if (type != null) {
                Iterator iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    ResId resId = ResId.of(this.mPackage.getId(), id, index);
                    if (value == null) {
                        if (this.mPackage.hasEntrySpec(id, index)) continue;
                        this.mMissingEntrySpecs.add(resId);
                        continue;
                    }
                    if (this.mPackage.hasEntry(id, index, config)) {
                        Log.w(TAG, "Ignoring repeated entry: id=%s, config=%s", resId, config);
                        continue;
                    }
                    if (!this.mPackage.hasEntrySpec(id, index)) {
                        this.mPackage.addEntrySpec(id, index, this.mKeyStringPool.getString(key));
                        this.mMissingEntrySpecs.remove(resId);
                    }
                    this.mPackage.addEntry(id, index, config, value);
                }
            }
            entryCount -= indexes.size();
        }
    }

    private ResConfig parseConfig() throws AndrolibException, IOException {
        int bytesRead;
        byte[] unknown;
        ResConfig config;
        long startPosition = this.mIn.position();
        int size = this.mIn.readInt();
        if (size < 8) {
            throw new AndrolibException("Config size < 8");
        }
        int mcc = this.mIn.readUnsignedShort();
        int mnc = this.mIn.readUnsignedShort();
        String language = "";
        String region = "";
        if (size >= 12) {
            language = this.unpackLanguageOrRegion(this.mIn.readBytes(2), 'a');
            region = this.unpackLanguageOrRegion(this.mIn.readBytes(2), '0');
        }
        int orientation = 0;
        int touchscreen = 0;
        if (size >= 14) {
            orientation = this.mIn.readUnsignedByte();
            touchscreen = this.mIn.readUnsignedByte();
        }
        int density = 0;
        if (size >= 16) {
            density = this.mIn.readUnsignedShort();
        }
        int keyboard = 0;
        int navigation = 0;
        int inputFlags = 0;
        int grammaticalInflection = 0;
        if (size >= 20) {
            keyboard = this.mIn.readUnsignedByte();
            navigation = this.mIn.readUnsignedByte();
            inputFlags = this.mIn.readUnsignedByte();
            grammaticalInflection = this.mIn.readUnsignedByte();
        }
        int screenWidth = 0;
        int screenHeight = 0;
        int sdkVersion = 0;
        int minorVersion = 0;
        if (size >= 28) {
            screenWidth = this.mIn.readUnsignedShort();
            screenHeight = this.mIn.readUnsignedShort();
            sdkVersion = this.mIn.readUnsignedShort();
            minorVersion = this.mIn.readUnsignedShort();
        }
        int screenLayout = 0;
        int uiMode = 0;
        int smallestScreenWidthDp = 0;
        if (size >= 32) {
            screenLayout = this.mIn.readUnsignedByte();
            uiMode = this.mIn.readUnsignedByte();
            smallestScreenWidthDp = this.mIn.readUnsignedShort();
        }
        int screenWidthDp = 0;
        int screenHeightDp = 0;
        if (size >= 36) {
            screenWidthDp = this.mIn.readUnsignedShort();
            screenHeightDp = this.mIn.readUnsignedShort();
        }
        String localeScript = "";
        String localeVariant = "";
        if (size >= 48) {
            localeScript = this.mIn.readAscii(4);
            localeVariant = this.mIn.readAscii(8);
        }
        int screenLayout2 = 0;
        int colorMode = 0;
        if (size >= 52) {
            screenLayout2 = this.mIn.readUnsignedByte();
            colorMode = this.mIn.readUnsignedByte();
            this.mIn.skipShort();
        }
        if ((config = new ResConfig(mcc, mnc, language, region, orientation, touchscreen, density, keyboard, navigation, inputFlags, grammaticalInflection, screenWidth, screenHeight, sdkVersion, minorVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, colorMode, unknown = this.readExceedingBytes("Config", size, bytesRead = (int)(this.mIn.position() - startPosition)))).isInvalid()) {
            this.mInvalidConfigs.add(config);
        }
        return config;
    }

    private String unpackLanguageOrRegion(byte[] in, char base) {
        assert (in.length == 2);
        if (in[0] == 0) {
            return "";
        }
        if ((in[0] & 0x80) != 0) {
            in = new byte[]{(byte)(base + (in[1] & 0x1F)), (byte)(base + ((in[1] & 0xE0) >>> 5) + ((in[0] & 3) << 3)), (byte)(base + ((in[0] & 0x7C) >>> 2))};
        }
        return new String(in, StandardCharsets.US_ASCII);
    }

    private Pair<Integer, ResValue> parseEntry(String typeName) throws AndrolibException, IOException {
        ResValue value;
        boolean isCompact;
        int size = this.mIn.readUnsignedShort();
        int flags = this.mIn.readUnsignedShort();
        int key = this.mIn.readInt();
        boolean isComplex = (flags & 1) != 0;
        boolean bl = isCompact = (flags & 8) != 0;
        if (key == -1 && !isCompact) {
            return null;
        }
        if (isCompact) {
            this.mCompactEntries = true;
        }
        if (isComplex && !isCompact) {
            value = this.parseBag(typeName);
        } else if (isCompact) {
            int type = flags >>> 8 & 0xFF;
            value = this.parseItem(typeName, false, type, key);
            key = size;
        } else {
            value = this.parseItem(typeName, false);
        }
        return Pair.of(key, value);
    }

    private ResValue parseBag(String typeName) throws AndrolibException, IOException {
        int parentId = this.mIn.readInt();
        int count = this.mIn.readInt();
        if (typeName.equals("id")) {
            return ResCustom.ID;
        }
        ResReference parent = new ResReference(this.mPackage, ResId.of(parentId));
        ResBag.RawItem[] rawItems = new ResBag.RawItem[count];
        int rawItemsCount = 0;
        for (int i = 0; i < count; ++i) {
            int name = this.mIn.readInt();
            ResItem value = (ResItem)this.parseItem(typeName, true);
            if (value == null) continue;
            rawItems[rawItemsCount++] = new ResBag.RawItem(name, value);
        }
        if (rawItemsCount < rawItems.length) {
            rawItems = Arrays.copyOf(rawItems, rawItemsCount);
        }
        return ResBag.parse(typeName, parent, rawItems);
    }

    private ResValue parseItem(String typeName, boolean inBag) throws AndrolibException, IOException {
        int size = this.mIn.readUnsignedShort();
        if (size < 8) {
            return null;
        }
        this.mIn.skipByte();
        int type = this.mIn.readUnsignedByte();
        int data = this.mIn.readInt();
        return this.parseItem(typeName, inBag, type, data);
    }

    private ResValue parseItem(String typeName, boolean inBag, int type, int data) throws AndrolibException {
        if (typeName.equals("id") && (data == 0 || type != 1 && type != 7)) {
            return ResCustom.ID;
        }
        if (type == 3) {
            if (this.mValueStringPool == null) {
                throw new AndrolibException("Missing value string pool.");
            }
            CharSequence strValue = this.mValueStringPool.getText(data);
            if (strValue instanceof String && strValue.length() > 0 && !inBag && !typeName.equals("string")) {
                return new ResFileReference((String)strValue);
            }
            return new ResString(strValue);
        }
        return ResItem.parse(this.mPackage, type, data);
    }

    private void parseLibrary(ResChunkPullParser parser) throws IOException {
        int count = this.mIn.readInt();
        this.skipUnreadHeader(parser);
        for (int i = 0; i < count; ++i) {
            int packageId = this.mIn.readInt();
            String packageName = this.mIn.readUtf16(128);
            if (packageId == 0 || packageName.isEmpty()) continue;
            this.mTable.addDynamicRefPackage(packageId, packageName);
        }
    }

    private void parseOverlayable(ResChunkPullParser parser) throws AndrolibException, IOException {
        ResOverlayable overlayable;
        String name = this.mIn.readUtf16(256);
        String actor = this.mIn.readUtf16(256);
        this.skipUnreadHeader(parser);
        if (name.isEmpty()) {
            return;
        }
        try {
            overlayable = this.mPackage.getOverlayable(name);
        }
        catch (UndefinedResObjectException ignored) {
            overlayable = this.mPackage.addOverlayable(name, actor);
        }
        parser = new ResChunkPullParser(this.mIn, parser.dataSize());
        while (this.nextChunk(parser)) {
            if (parser.chunkType() != 517) {
                this.skipUnexpectedChunk(parser);
                continue;
            }
            int flags = this.mIn.readInt();
            int entryCount = this.mIn.readInt();
            this.skipUnreadHeader(parser);
            ResId[] entries = new ResId[entryCount];
            int entriesCount = 0;
            for (int i = 0; i < entryCount; ++i) {
                entries[entriesCount++] = ResId.of(this.mIn.readInt());
            }
            if (entriesCount < entries.length) {
                entries = Arrays.copyOf(entries, entriesCount);
            }
            overlayable.addPolicy(flags, entries);
        }
    }

    private void parseStagedAliases(ResChunkPullParser parser) throws AndrolibException, IOException {
        int count = this.mIn.readInt();
        this.skipUnreadHeader(parser);
        for (int i = 0; i < count; ++i) {
            int stagedResId = this.mIn.readInt();
            int finalizedResId = this.mIn.readInt();
            if (stagedResId == 0 || finalizedResId == 0) continue;
            this.mPackage.addAlias(ResId.of(stagedResId), ResId.of(finalizedResId));
        }
    }

    private void skipUnexpectedChunk(ResChunkPullParser parser) throws IOException {
        Log.w(TAG, "Skipping unexpected %s chunk of %s bytes at 0x%08x.", parser.chunkName(), parser.chunkSize(), parser.chunkStart());
        parser.skipChunk();
    }

    private void skipUnreadHeader(ResChunkPullParser parser) throws IOException {
        int bytesRead = (int)(this.mIn.position() - parser.chunkStart());
        this.readExceedingBytes("Chunk header", parser.headerSize(), bytesRead);
    }

    private byte[] readExceedingBytes(String name, int size, int bytesRead) throws IOException {
        int bytesExceeding = size - bytesRead;
        if (bytesExceeding > 0) {
            byte[] buf = this.mIn.readBytes(bytesExceeding);
            for (int i = 0; i < buf.length; ++i) {
                if (buf[i] == 0) continue;
                Log.w(TAG, "%s size: %s bytes, read: %s bytes. Exceeding bytes: %s", name, size, bytesRead, BaseEncoding.base16().encode(buf));
                return buf;
            }
        }
        return null;
    }

    private void injectDummyEntrySpecs() throws AndrolibException {
        if (this.mAllowDummyEntrySpecs) {
            ResReference parent = new ResReference(this.mPackage, ResId.NULL);
            ResBag.RawItem[] rawItems = new ResBag.RawItem[]{};
            for (ResId resId : this.mMissingEntrySpecs) {
                ResTypeSpec typeSpec = this.mPackage.getTypeSpec(resId.typeId());
                String typeName = typeSpec.getName();
                ResValue value = typeName.equals("id") ? ResCustom.ID : (typeName.equals("string") ? ResString.EMPTY : (typeSpec.isBagType() ? ResBag.parse(typeName, parent, rawItems) : ResPrimitive.NULL));
                this.mPackage.addEntrySpec(resId.typeId(), resId.entryId(), "APKTOOL_DUMMY_" + resId);
                this.mPackage.addEntry(resId.typeId(), resId.entryId(), value);
            }
        }
        this.mMissingEntrySpecs.clear();
    }
}

