/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import brut.util.BrutIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public final class Jar {
    private static final Map<String, File> sExtracted = new HashMap<String, File>();

    private Jar() {
    }

    public static File getResourceAsFile(Class<?> clz, String name) throws BrutException {
        return Jar.getResourceAsFile(clz, name, "brut_util_Jar_");
    }

    public static File getResourceAsFile(Class<?> clz, String name, String tmpPrefix) throws BrutException {
        File file = sExtracted.get(name);
        if (file == null) {
            file = Jar.extractToTmp(clz, name, tmpPrefix);
            sExtracted.put(name, file);
        }
        return file;
    }

    public static File extractToTmp(Class<?> clz, String name) throws BrutException {
        return Jar.extractToTmp(clz, name, "brut_util_Jar_");
    }

    public static File extractToTmp(Class<?> clz, String name, String tmpPrefix) throws BrutException {
        File file;
        block9: {
            InputStream in = clz.getResourceAsStream(name);
            try {
                if (in == null) {
                    throw new FileNotFoundException(name);
                }
                long suffix = ThreadLocalRandom.current().nextLong();
                suffix = suffix > Long.MIN_VALUE ? Math.abs(suffix) : 0L;
                File fileOut = File.createTempFile(tmpPrefix, suffix + ".tmp");
                fileOut.deleteOnExit();
                BrutIO.copyAndClose(in, Files.newOutputStream(fileOut.toPath(), new OpenOption[0]));
                file = fileOut;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new BrutException("Could not extract resource: " + name, ex);
                }
            }
            in.close();
        }
        return file;
    }
}

