/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.xml;

import brut.common.Log;
import brut.util.TextUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlSerializer
implements XmlSerializer {
    private static final String TAG = ResXmlSerializer.class.getName();
    private static final String NOT_SUPPORTED = "Method is not supported.";
    private static final int BUFFER_SIZE = 8192;
    private final boolean mAutoEscape;
    private final char[] mBuffer;
    private boolean[] mIndent;
    private String[] mElementStack;
    private int[] mNamespaceCounts;
    private String[] mNamespaceStack;
    private Writer mWriter;
    private int mDepth;
    private boolean mPending;
    private int mAutoNamespace;
    private int mBufferIndex;

    public ResXmlSerializer(boolean autoEscape) {
        this.mAutoEscape = autoEscape;
        this.mBuffer = new char[8192];
        this.mIndent = new boolean[4];
        this.mElementStack = new String[12];
        this.mNamespaceCounts = new int[6];
        this.mNamespaceStack = new String[12];
    }

    @Override
    public void setFeature(String name, boolean state) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public void setProperty(String name, Object value) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setOutput(OutputStream os, String encoding) throws IOException {
        if (encoding != null && !encoding.equalsIgnoreCase(StandardCharsets.UTF_8.name())) {
            throw new UnsupportedOperationException();
        }
        this.setOutput(new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }

    @Override
    public void setOutput(Writer writer) {
        this.mWriter = writer;
        this.mDepth = 0;
        this.mIndent[0] = true;
        this.mPending = false;
        this.mAutoNamespace = 0;
        this.mNamespaceCounts[0] = 3;
        this.mNamespaceCounts[1] = 3;
        this.mNamespaceStack[0] = "";
        this.mNamespaceStack[1] = "";
        this.mNamespaceStack[2] = "xml";
        this.mNamespaceStack[3] = "http://www.w3.org/XML/1998/namespace";
        this.mNamespaceStack[4] = "xmlns";
        this.mNamespaceStack[5] = "http://www.w3.org/2000/xmlns/";
    }

    @Override
    public void startDocument(String encoding, Boolean standalone) throws IOException {
        this.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
    }

    @Override
    public void endDocument() throws IOException {
        while (this.mDepth > 0) {
            this.endTag(this.mElementStack[this.mDepth * 3 - 3], this.mElementStack[this.mDepth * 3 - 1]);
        }
        this.write(System.lineSeparator());
        this.flush();
    }

    @Override
    public void setPrefix(String prefix, String namespace) throws IOException {
        this.check(false);
        if (prefix == null) {
            prefix = "";
        }
        if (namespace == null) {
            namespace = "";
        }
        if (prefix.equals(this.getPrefix(namespace, true, false))) {
            return;
        }
        int n = this.mDepth + 1;
        int n2 = this.mNamespaceCounts[n];
        this.mNamespaceCounts[n] = n2 + 1;
        int i = n2 << 1;
        if (this.mNamespaceStack.length < i + 1) {
            String[] newStack = new String[this.mNamespaceStack.length + 16];
            System.arraycopy(this.mNamespaceStack, 0, newStack, 0, i);
            this.mNamespaceStack = newStack;
        }
        this.mNamespaceStack[i++] = prefix;
        this.mNamespaceStack[i] = namespace;
    }

    @Override
    public String getPrefix(String namespace, boolean generatePrefix) {
        try {
            return this.getPrefix(namespace, false, generatePrefix);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getPrefix(String namespace, boolean includeDefault, boolean generatePrefix) throws IOException {
        String prefix;
        for (int i = this.mNamespaceCounts[this.mDepth + 1] * 2 - 2; i >= 0; i -= 2) {
            if (!this.mNamespaceStack[i + 1].equals(namespace) || !includeDefault && this.mNamespaceStack[i].isEmpty()) continue;
            String candidate = this.mNamespaceStack[i];
            for (int j = i + 2; j < this.mNamespaceCounts[this.mDepth + 1] * 2; ++j) {
                if (!this.mNamespaceStack[j].equals(candidate)) continue;
                candidate = null;
                break;
            }
            if (candidate == null) continue;
            return candidate;
        }
        if (!generatePrefix) {
            return null;
        }
        if (namespace.isEmpty()) {
            prefix = "";
        } else {
            block2: do {
                prefix = "n" + this.mAutoNamespace++;
                for (int i = this.mNamespaceCounts[this.mDepth + 1] * 2 - 2; i >= 0; i -= 2) {
                    if (!prefix.equals(this.mNamespaceStack[i])) continue;
                    prefix = null;
                    continue block2;
                }
            } while (prefix == null);
        }
        boolean pending = this.mPending;
        this.mPending = false;
        this.setPrefix(prefix, namespace);
        this.mPending = pending;
        return prefix;
    }

    @Override
    public int getDepth() {
        return this.mPending ? this.mDepth + 1 : this.mDepth;
    }

    @Override
    public String getNamespace() {
        int depth = this.getDepth();
        return depth > 0 ? this.mElementStack[depth * 3 - 3] : null;
    }

    @Override
    public String getName() {
        int depth = this.getDepth();
        return depth > 0 ? this.mElementStack[depth * 3 - 1] : null;
    }

    @Override
    public XmlSerializer startTag(String namespace, String name) throws IOException {
        String prefix;
        this.check(false);
        this.writeIndent();
        int i = this.mDepth * 3;
        if (this.mElementStack.length < i + 3) {
            String[] newStack = new String[this.mElementStack.length + 12];
            System.arraycopy(this.mElementStack, 0, newStack, 0, i);
            this.mElementStack = newStack;
        }
        String string = prefix = namespace != null ? this.getPrefix(namespace, true, true) : "";
        if (namespace != null && namespace.isEmpty()) {
            for (int j = this.mNamespaceCounts[this.mDepth]; j < this.mNamespaceCounts[this.mDepth + 1]; ++j) {
                if (!this.mNamespaceStack[j * 2].isEmpty() || this.mNamespaceStack[j * 2 + 1].isEmpty()) continue;
                throw new IllegalStateException("Could not set default namespace for elements in no namespace.");
            }
        }
        this.mElementStack[i++] = namespace;
        this.mElementStack[i++] = prefix;
        this.mElementStack[i] = name;
        this.write('<');
        if (!prefix.isEmpty()) {
            this.write(prefix);
            this.write(':');
        }
        this.write(name);
        this.mIndent[this.mDepth] = true;
        this.mPending = true;
        return this;
    }

    @Override
    public XmlSerializer endTag(String namespace, String name) throws IOException {
        if (!this.mPending) {
            --this.mDepth;
        }
        if (namespace == null && this.mElementStack[this.mDepth * 3] != null || namespace != null && !namespace.equals(this.mElementStack[this.mDepth * 3]) || !this.mElementStack[this.mDepth * 3 + 2].equals(name)) {
            throw new IllegalArgumentException("</{" + namespace + "}" + name + "> does not match start.");
        }
        if (this.mPending) {
            this.check(true);
            --this.mDepth;
        } else {
            if (this.mIndent[this.mDepth + 1]) {
                this.writeIndent();
            }
            this.write("</");
            String prefix = this.mElementStack[this.mDepth * 3 + 1];
            if (!prefix.isEmpty()) {
                this.write(prefix);
                this.write(':');
            }
            this.write(name);
            this.write('>');
        }
        this.mNamespaceCounts[this.mDepth + 1] = this.mNamespaceCounts[this.mDepth];
        return this;
    }

    @Override
    public XmlSerializer attribute(String namespace, String name, String value) throws IOException {
        String prefix;
        if (!this.mPending) {
            throw new IllegalStateException("Illegal position for attribute.");
        }
        if (namespace == null) {
            namespace = "";
        }
        this.write(' ');
        String string = prefix = !namespace.isEmpty() ? this.getPrefix(namespace, false, true) : "";
        if (!prefix.isEmpty()) {
            this.write(prefix);
            this.write(':');
        }
        this.write(name);
        this.write("=\"");
        if (this.mAutoEscape) {
            this.writeEscaped(value, true);
        } else {
            this.write(value);
        }
        this.write('\"');
        return this;
    }

    @Override
    public XmlSerializer text(String text) throws IOException {
        this.check(false);
        this.mIndent[this.mDepth] = false;
        if (this.mAutoEscape) {
            this.writeEscaped(text, false);
        } else {
            this.write(text);
        }
        return this;
    }

    @Override
    public XmlSerializer text(char[] buf, int start, int len) throws IOException {
        return this.text(new String(buf, start, len));
    }

    @Override
    public void cdsect(String text) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void entityRef(String text) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void processingInstruction(String text) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void comment(String text) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void docdecl(String text) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void ignorableWhitespace(String text) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void flush() throws IOException {
        this.check(false);
        this.flushBuffer();
    }

    private void check(boolean close) throws IOException {
        if (!this.mPending) {
            return;
        }
        if (this.mIndent[this.mDepth] && this.mNamespaceCounts[this.mDepth] < this.mNamespaceCounts[this.mDepth + 1]) {
            this.writeIndent();
            this.write(' ');
        }
        this.mPending = false;
        ++this.mDepth;
        if (this.mIndent.length <= this.mDepth) {
            boolean[] newIndent = new boolean[this.mDepth + 4];
            System.arraycopy(this.mIndent, 0, newIndent, 0, this.mDepth);
            this.mIndent = newIndent;
        }
        this.mIndent[this.mDepth] = this.mIndent[this.mDepth - 1];
        for (int i = this.mNamespaceCounts[this.mDepth - 1]; i < this.mNamespaceCounts[this.mDepth]; ++i) {
            String prefix = this.mNamespaceStack[i * 2];
            String uri = this.mNamespaceStack[i * 2 + 1];
            this.write(" xmlns");
            if (!prefix.isEmpty()) {
                this.write(':');
                this.write(prefix);
            } else if (this.getNamespace().isEmpty() && !uri.isEmpty()) {
                throw new IllegalStateException("Could not set default namespace for elements in no namespace.");
            }
            this.write("=\"");
            if (this.mAutoEscape) {
                this.writeEscaped(uri, true);
            } else {
                this.write(uri);
            }
            this.write('\"');
        }
        if (this.mNamespaceCounts.length <= this.mDepth + 1) {
            int[] newCounts = new int[this.mDepth + 8];
            System.arraycopy(this.mNamespaceCounts, 0, newCounts, 0, this.mDepth + 1);
            this.mNamespaceCounts = newCounts;
        }
        this.mNamespaceCounts[this.mDepth + 1] = this.mNamespaceCounts[this.mDepth];
        if (close) {
            this.write(" />");
        } else {
            this.write('>');
        }
    }

    private void flushBuffer() throws IOException {
        if (this.mBufferIndex > 0) {
            this.mWriter.write(this.mBuffer, 0, this.mBufferIndex);
            this.mWriter.flush();
            this.mBufferIndex = 0;
        }
    }

    private void writeIndent() throws IOException {
        this.write(System.lineSeparator());
        int len = this.mDepth * 4;
        while (len > 0) {
            int batch;
            if (this.mBufferIndex == 8192) {
                this.flushBuffer();
            }
            if ((batch = 8192 - this.mBufferIndex) > len) {
                batch = len;
            }
            Arrays.fill(this.mBuffer, this.mBufferIndex, this.mBufferIndex + batch, ' ');
            len -= batch;
            this.mBufferIndex += batch;
        }
    }

    private void write(char ch) throws IOException {
        if (this.mBufferIndex >= 8192) {
            this.flushBuffer();
        }
        this.mBuffer[this.mBufferIndex++] = ch;
    }

    private void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    private void write(String str, int start, int len) throws IOException {
        while (len > 0) {
            int batch;
            if (this.mBufferIndex == 8192) {
                this.flushBuffer();
            }
            if ((batch = 8192 - this.mBufferIndex) > len) {
                batch = len;
            }
            str.getChars(start, start + batch, this.mBuffer, this.mBufferIndex);
            start += batch;
            len -= batch;
            this.mBufferIndex += batch;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeEscaped(String str, boolean attr) throws IOException {
        char ch = '\u0000';
        char prev = '\u0000';
        char prev2 = '\u0000';
        int i = 0;
        int n = str.length();
        while (true) {
            block6: {
                block8: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block7: {
                                                if (i >= n) {
                                                    return;
                                                }
                                                ch = str.charAt(i);
                                                if (ch != '\n') break block7;
                                                if (!attr) break block8;
                                                this.write("&#xA;");
                                                break block6;
                                            }
                                            if (ch != '\r') break block9;
                                            if (!attr) break block8;
                                            this.write("&#xD;");
                                            break block6;
                                        }
                                        if (ch != '\t') break block10;
                                        if (!attr) break block8;
                                        this.write("&#x9;");
                                        break block6;
                                    }
                                    if (ch != '\"') break block11;
                                    if (!attr) break block8;
                                    this.write("&quot;");
                                    break block6;
                                }
                                if (ch != '&') break block12;
                                this.write("&amp;");
                                break block6;
                            }
                            if (ch != '<') break block13;
                            this.write("&lt;");
                            break block6;
                        }
                        if (ch != '>') break block14;
                        if (prev != ']' || prev2 != ']') break block8;
                        this.write("&gt;");
                        break block6;
                    }
                    if (TextUtils.isPrintableChar(ch)) break block8;
                    if (Character.isHighSurrogate(ch) && i < n - 1) {
                        char low = str.charAt(i + 1);
                        if (Character.isLowSurrogate(low)) {
                            this.write(ch);
                            this.write(low);
                            ++i;
                            break block6;
                        } else {
                            Log.w(TAG, "Bad surrogate pair (U+%04x U+%04x)", ch, low);
                        }
                        break block6;
                    } else {
                        Log.w(TAG, "Illegal character (U+%04x)", ch);
                    }
                    break block6;
                }
                this.write(ch);
            }
            ++i;
            prev2 = prev;
            prev = ch;
        }
    }
}

