/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResItem;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class ResReference
extends ResItem {
    private final ResPackage mPackage;
    private final ResId mResId;
    private final boolean mAsAttr;

    public ResReference(ResPackage pkg, ResId resId) {
        this(pkg, resId, false);
    }

    public ResReference(ResPackage pkg, ResId resId, boolean asAttr) {
        super(asAttr ? 2 : 1);
        assert (pkg != null && resId != null);
        this.mPackage = pkg;
        this.mResId = resId;
        this.mAsAttr = asAttr;
    }

    public ResPackage getPackage() {
        return this.mPackage;
    }

    public ResId getResId() {
        return this.mResId;
    }

    public ResEntrySpec resolve() throws AndrolibException {
        if (this.mPackage != null && this.mResId != ResId.NULL) {
            ResId resId = this.fixDynamicResourceId(this.mResId);
            try {
                return this.mPackage.getTable().resolve(resId);
            }
            catch (UndefinedResObjectException undefinedResObjectException) {
                // empty catch block
            }
        }
        return null;
    }

    public ResEntry resolveEntry() throws AndrolibException {
        if (this.mPackage != null && this.mResId != ResId.NULL) {
            ResId resId = this.fixDynamicResourceId(this.mResId);
            try {
                return this.mPackage.getTable().resolveEntry(resId);
            }
            catch (UndefinedResObjectException undefinedResObjectException) {
                // empty catch block
            }
        }
        return null;
    }

    private ResId fixDynamicResourceId(ResId resId) {
        if (resId.pkgId() == 0 && this.mPackage.getId() != 0) {
            resId = ResId.of(this.mPackage.getId(), resId.typeId(), resId.entryId());
        }
        return resId;
    }

    @Override
    public String toXmlTextValue() throws AndrolibException {
        ResEntrySpec spec = this.resolve();
        if (spec == null) {
            return "@null";
        }
        boolean includePackage = this.mPackage.getGroup() != spec.getPackage().getGroup();
        boolean includeType = !this.mAsAttr || !spec.getTypeSpec().getName().equals("attr");
        return (this.mAsAttr ? "?" : "@") + (includePackage ? spec.getPackage().getName() + ":" : "") + (includeType ? spec.getTypeSpec().getName() + "/" : "") + spec.getName();
    }

    @Override
    public void serializeToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        String typeName = entry.getType().getName();
        boolean asItem = entry.getType().isBagType();
        boolean needsBody = this.resolve() != null || typeName.equals("string");
        String tagName = asItem ? "item" : typeName;
        serial.startTag(null, tagName);
        if (asItem) {
            serial.attribute(null, "type", typeName);
        }
        serial.attribute(null, "name", entry.getName());
        if (needsBody) {
            serial.text(this.toXmlTextValue());
        }
        serial.endTag(null, tagName);
    }

    public String toString() {
        return String.format("ResReference{pkg=%s, id=%s, type=%s}", this.mPackage, this.mResId, this.mAsAttr ? "attr" : "ref");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResReference) {
            ResReference other = (ResReference)obj;
            return this.mPackage.equals(other.mPackage) && this.mResId == other.mResId && this.mAsAttr == other.mAsAttr;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mPackage, this.mResId, this.mAsAttr);
    }
}

